package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteGlobalNetworkResponse(
    globalNetwork: Option[zio.aws.networkmanager.model.GlobalNetwork] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.DeleteGlobalNetworkResponse = {
    import DeleteGlobalNetworkResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.DeleteGlobalNetworkResponse
      .builder()
      .optionallyWith(globalNetwork.map(value => value.buildAwsValue()))(
        _.globalNetwork
      )
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.DeleteGlobalNetworkResponse.ReadOnly =
    zio.aws.networkmanager.model.DeleteGlobalNetworkResponse
      .wrap(buildAwsValue())
}
object DeleteGlobalNetworkResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.DeleteGlobalNetworkResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.DeleteGlobalNetworkResponse =
      zio.aws.networkmanager.model.DeleteGlobalNetworkResponse(
        globalNetwork.map(value => value.asEditable)
      )
    def globalNetwork
        : Option[zio.aws.networkmanager.model.GlobalNetwork.ReadOnly]
    def getGlobalNetwork: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.GlobalNetwork.ReadOnly
    ] = AwsError.unwrapOptionField("globalNetwork", globalNetwork)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.DeleteGlobalNetworkResponse
  ) extends zio.aws.networkmanager.model.DeleteGlobalNetworkResponse.ReadOnly {
    override val globalNetwork
        : Option[zio.aws.networkmanager.model.GlobalNetwork.ReadOnly] = scala
      .Option(impl.globalNetwork())
      .map(value => zio.aws.networkmanager.model.GlobalNetwork.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.DeleteGlobalNetworkResponse
  ): zio.aws.networkmanager.model.DeleteGlobalNetworkResponse.ReadOnly =
    new Wrapper(impl)
}
