package zio.aws.networkmanager.model
import scala.jdk.CollectionConverters._
sealed trait RouteTableType {
  def unwrap
      : software.amazon.awssdk.services.networkmanager.model.RouteTableType
}
object RouteTableType {
  def wrap(
      value: software.amazon.awssdk.services.networkmanager.model.RouteTableType
  ): zio.aws.networkmanager.model.RouteTableType = value match {
    case software.amazon.awssdk.services.networkmanager.model.RouteTableType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.networkmanager.model.RouteTableType.TRANSIT_GATEWAY_ROUTE_TABLE =>
      val r = TRANSIT_GATEWAY_ROUTE_TABLE
      r
    case software.amazon.awssdk.services.networkmanager.model.RouteTableType.CORE_NETWORK_SEGMENT =>
      val r = CORE_NETWORK_SEGMENT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.networkmanager.model.RouteTableType {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.RouteTableType =
      software.amazon.awssdk.services.networkmanager.model.RouteTableType.UNKNOWN_TO_SDK_VERSION
  }
  case object TRANSIT_GATEWAY_ROUTE_TABLE
      extends zio.aws.networkmanager.model.RouteTableType {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.RouteTableType =
      software.amazon.awssdk.services.networkmanager.model.RouteTableType.TRANSIT_GATEWAY_ROUTE_TABLE
  }
  case object CORE_NETWORK_SEGMENT
      extends zio.aws.networkmanager.model.RouteTableType {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.RouteTableType =
      software.amazon.awssdk.services.networkmanager.model.RouteTableType.CORE_NETWORK_SEGMENT
  }
}
