package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.networkfirewall.model.primitives.{
  UpdateToken,
  Description,
  ResourceName,
  ResourceArn
}
import scala.jdk.CollectionConverters.*
final case class UpdateTlsInspectionConfigurationRequest(
    tlsInspectionConfigurationArn: Optional[ResourceArn] = Optional.Absent,
    tlsInspectionConfigurationName: Optional[ResourceName] = Optional.Absent,
    tlsInspectionConfiguration: zio.aws.networkfirewall.model.TLSInspectionConfiguration,
    description: Optional[Description] = Optional.Absent,
    encryptionConfiguration: Optional[
      zio.aws.networkfirewall.model.EncryptionConfiguration
    ] = Optional.Absent,
    updateToken: UpdateToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.UpdateTlsInspectionConfigurationRequest = {
    import UpdateTlsInspectionConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.UpdateTlsInspectionConfigurationRequest
      .builder()
      .optionallyWith(
        tlsInspectionConfigurationArn.map(value =>
          ResourceArn.unwrap(value): java.lang.String
        )
      )(_.tlsInspectionConfigurationArn)
      .optionallyWith(
        tlsInspectionConfigurationName.map(value =>
          ResourceName.unwrap(value): java.lang.String
        )
      )(_.tlsInspectionConfigurationName)
      .tlsInspectionConfiguration(tlsInspectionConfiguration.buildAwsValue())
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        encryptionConfiguration.map(value => value.buildAwsValue())
      )(_.encryptionConfiguration)
      .updateToken(UpdateToken.unwrap(updateToken): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.UpdateTlsInspectionConfigurationRequest.ReadOnly =
    zio.aws.networkfirewall.model.UpdateTlsInspectionConfigurationRequest
      .wrap(buildAwsValue())
}
object UpdateTlsInspectionConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.UpdateTlsInspectionConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkfirewall.model.UpdateTlsInspectionConfigurationRequest =
      zio.aws.networkfirewall.model.UpdateTlsInspectionConfigurationRequest(
        tlsInspectionConfigurationArn.map(value => value),
        tlsInspectionConfigurationName.map(value => value),
        tlsInspectionConfiguration.asEditable,
        description.map(value => value),
        encryptionConfiguration.map(value => value.asEditable),
        updateToken
      )
    def tlsInspectionConfigurationArn: Optional[ResourceArn]
    def tlsInspectionConfigurationName: Optional[ResourceName]
    def tlsInspectionConfiguration
        : zio.aws.networkfirewall.model.TLSInspectionConfiguration.ReadOnly
    def description: Optional[Description]
    def encryptionConfiguration: Optional[
      zio.aws.networkfirewall.model.EncryptionConfiguration.ReadOnly
    ]
    def updateToken: UpdateToken
    def getTlsInspectionConfigurationArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField(
        "tlsInspectionConfigurationArn",
        tlsInspectionConfigurationArn
      )
    def getTlsInspectionConfigurationName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField(
        "tlsInspectionConfigurationName",
        tlsInspectionConfigurationName
      )
    def getTlsInspectionConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.networkfirewall.model.TLSInspectionConfiguration.ReadOnly
    ] = ZIO.succeed(tlsInspectionConfiguration)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getEncryptionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.networkfirewall.model.EncryptionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "encryptionConfiguration",
      encryptionConfiguration
    )
    def getUpdateToken: ZIO[Any, Nothing, UpdateToken] =
      ZIO.succeed(updateToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.UpdateTlsInspectionConfigurationRequest
  ) extends zio.aws.networkfirewall.model.UpdateTlsInspectionConfigurationRequest.ReadOnly {
    override val tlsInspectionConfigurationArn: Optional[ResourceArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tlsInspectionConfigurationArn())
        .map(value =>
          zio.aws.networkfirewall.model.primitives.ResourceArn(value)
        )
    override val tlsInspectionConfigurationName: Optional[ResourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tlsInspectionConfigurationName())
        .map(value =>
          zio.aws.networkfirewall.model.primitives.ResourceName(value)
        )
    override val tlsInspectionConfiguration
        : zio.aws.networkfirewall.model.TLSInspectionConfiguration.ReadOnly =
      zio.aws.networkfirewall.model.TLSInspectionConfiguration
        .wrap(impl.tlsInspectionConfiguration())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.networkfirewall.model.primitives.Description(value))
    override val encryptionConfiguration: Optional[
      zio.aws.networkfirewall.model.EncryptionConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.encryptionConfiguration())
      .map(value =>
        zio.aws.networkfirewall.model.EncryptionConfiguration.wrap(value)
      )
    override val updateToken: UpdateToken =
      zio.aws.networkfirewall.model.primitives.UpdateToken(impl.updateToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.UpdateTlsInspectionConfigurationRequest
  ): zio.aws.networkfirewall.model.UpdateTlsInspectionConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
