package zio.aws.networkfirewall.model
import scala.jdk.CollectionConverters.*
sealed trait StatefulRuleProtocol {
  def unwrap: software.amazon.awssdk.services.networkfirewall.model.StatefulRuleProtocol
}
object StatefulRuleProtocol {
  def wrap(
      value: software.amazon.awssdk.services.networkfirewall.model.StatefulRuleProtocol
  ): zio.aws.networkfirewall.model.StatefulRuleProtocol = value match {
    case software.amazon.awssdk.services.networkfirewall.model.StatefulRuleProtocol.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.networkfirewall.model.StatefulRuleProtocol.IP =>
      val r = IP
      r
    case software.amazon.awssdk.services.networkfirewall.model.StatefulRuleProtocol.TCP =>
      val r = TCP
      r
    case software.amazon.awssdk.services.networkfirewall.model.StatefulRuleProtocol.UDP =>
      val r = UDP
      r
    case software.amazon.awssdk.services.networkfirewall.model.StatefulRuleProtocol.ICMP =>
      val r = ICMP
      r
    case software.amazon.awssdk.services.networkfirewall.model.StatefulRuleProtocol.HTTP =>
      val r = HTTP
      r
    case software.amazon.awssdk.services.networkfirewall.model.StatefulRuleProtocol.FTP =>
      val r = FTP
      r
    case software.amazon.awssdk.services.networkfirewall.model.StatefulRuleProtocol.TLS =>
      val r = TLS
      r
    case software.amazon.awssdk.services.networkfirewall.model.StatefulRuleProtocol.SMB =>
      val r = SMB
      r
    case software.amazon.awssdk.services.networkfirewall.model.StatefulRuleProtocol.DNS =>
      val r = DNS
      r
    case software.amazon.awssdk.services.networkfirewall.model.StatefulRuleProtocol.DCERPC =>
      val r = DCERPC
      r
    case software.amazon.awssdk.services.networkfirewall.model.StatefulRuleProtocol.SSH =>
      val r = SSH
      r
    case software.amazon.awssdk.services.networkfirewall.model.StatefulRuleProtocol.SMTP =>
      val r = SMTP
      r
    case software.amazon.awssdk.services.networkfirewall.model.StatefulRuleProtocol.IMAP =>
      val r = IMAP
      r
    case software.amazon.awssdk.services.networkfirewall.model.StatefulRuleProtocol.MSN =>
      val r = MSN
      r
    case software.amazon.awssdk.services.networkfirewall.model.StatefulRuleProtocol.KRB5 =>
      val r = KRB5
      r
    case software.amazon.awssdk.services.networkfirewall.model.StatefulRuleProtocol.IKEV2 =>
      val r = IKEV2
      r
    case software.amazon.awssdk.services.networkfirewall.model.StatefulRuleProtocol.TFTP =>
      val r = TFTP
      r
    case software.amazon.awssdk.services.networkfirewall.model.StatefulRuleProtocol.NTP =>
      val r = NTP
      r
    case software.amazon.awssdk.services.networkfirewall.model.StatefulRuleProtocol.DHCP =>
      val r = DHCP
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.networkfirewall.model.StatefulRuleProtocol {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.StatefulRuleProtocol =
      software.amazon.awssdk.services.networkfirewall.model.StatefulRuleProtocol.UNKNOWN_TO_SDK_VERSION
  }
  case object IP extends zio.aws.networkfirewall.model.StatefulRuleProtocol {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.StatefulRuleProtocol =
      software.amazon.awssdk.services.networkfirewall.model.StatefulRuleProtocol.IP
  }
  case object TCP extends zio.aws.networkfirewall.model.StatefulRuleProtocol {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.StatefulRuleProtocol =
      software.amazon.awssdk.services.networkfirewall.model.StatefulRuleProtocol.TCP
  }
  case object UDP extends zio.aws.networkfirewall.model.StatefulRuleProtocol {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.StatefulRuleProtocol =
      software.amazon.awssdk.services.networkfirewall.model.StatefulRuleProtocol.UDP
  }
  case object ICMP extends zio.aws.networkfirewall.model.StatefulRuleProtocol {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.StatefulRuleProtocol =
      software.amazon.awssdk.services.networkfirewall.model.StatefulRuleProtocol.ICMP
  }
  case object HTTP extends zio.aws.networkfirewall.model.StatefulRuleProtocol {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.StatefulRuleProtocol =
      software.amazon.awssdk.services.networkfirewall.model.StatefulRuleProtocol.HTTP
  }
  case object FTP extends zio.aws.networkfirewall.model.StatefulRuleProtocol {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.StatefulRuleProtocol =
      software.amazon.awssdk.services.networkfirewall.model.StatefulRuleProtocol.FTP
  }
  case object TLS extends zio.aws.networkfirewall.model.StatefulRuleProtocol {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.StatefulRuleProtocol =
      software.amazon.awssdk.services.networkfirewall.model.StatefulRuleProtocol.TLS
  }
  case object SMB extends zio.aws.networkfirewall.model.StatefulRuleProtocol {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.StatefulRuleProtocol =
      software.amazon.awssdk.services.networkfirewall.model.StatefulRuleProtocol.SMB
  }
  case object DNS extends zio.aws.networkfirewall.model.StatefulRuleProtocol {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.StatefulRuleProtocol =
      software.amazon.awssdk.services.networkfirewall.model.StatefulRuleProtocol.DNS
  }
  case object DCERPC
      extends zio.aws.networkfirewall.model.StatefulRuleProtocol {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.StatefulRuleProtocol =
      software.amazon.awssdk.services.networkfirewall.model.StatefulRuleProtocol.DCERPC
  }
  case object SSH extends zio.aws.networkfirewall.model.StatefulRuleProtocol {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.StatefulRuleProtocol =
      software.amazon.awssdk.services.networkfirewall.model.StatefulRuleProtocol.SSH
  }
  case object SMTP extends zio.aws.networkfirewall.model.StatefulRuleProtocol {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.StatefulRuleProtocol =
      software.amazon.awssdk.services.networkfirewall.model.StatefulRuleProtocol.SMTP
  }
  case object IMAP extends zio.aws.networkfirewall.model.StatefulRuleProtocol {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.StatefulRuleProtocol =
      software.amazon.awssdk.services.networkfirewall.model.StatefulRuleProtocol.IMAP
  }
  case object MSN extends zio.aws.networkfirewall.model.StatefulRuleProtocol {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.StatefulRuleProtocol =
      software.amazon.awssdk.services.networkfirewall.model.StatefulRuleProtocol.MSN
  }
  case object KRB5 extends zio.aws.networkfirewall.model.StatefulRuleProtocol {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.StatefulRuleProtocol =
      software.amazon.awssdk.services.networkfirewall.model.StatefulRuleProtocol.KRB5
  }
  case object IKEV2 extends zio.aws.networkfirewall.model.StatefulRuleProtocol {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.StatefulRuleProtocol =
      software.amazon.awssdk.services.networkfirewall.model.StatefulRuleProtocol.IKEV2
  }
  case object TFTP extends zio.aws.networkfirewall.model.StatefulRuleProtocol {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.StatefulRuleProtocol =
      software.amazon.awssdk.services.networkfirewall.model.StatefulRuleProtocol.TFTP
  }
  case object NTP extends zio.aws.networkfirewall.model.StatefulRuleProtocol {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.StatefulRuleProtocol =
      software.amazon.awssdk.services.networkfirewall.model.StatefulRuleProtocol.NTP
  }
  case object DHCP extends zio.aws.networkfirewall.model.StatefulRuleProtocol {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.StatefulRuleProtocol =
      software.amazon.awssdk.services.networkfirewall.model.StatefulRuleProtocol.DHCP
  }
}
