package zio.aws.networkfirewall.model
import scala.jdk.CollectionConverters.*
sealed trait RevocationCheckAction {
  def unwrap: software.amazon.awssdk.services.networkfirewall.model.RevocationCheckAction
}
object RevocationCheckAction {
  def wrap(
      value: software.amazon.awssdk.services.networkfirewall.model.RevocationCheckAction
  ): zio.aws.networkfirewall.model.RevocationCheckAction = value match {
    case software.amazon.awssdk.services.networkfirewall.model.RevocationCheckAction.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.networkfirewall.model.RevocationCheckAction.PASS =>
      val r = PASS
      r
    case software.amazon.awssdk.services.networkfirewall.model.RevocationCheckAction.DROP =>
      val r = DROP
      r
    case software.amazon.awssdk.services.networkfirewall.model.RevocationCheckAction.REJECT =>
      val r = REJECT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.networkfirewall.model.RevocationCheckAction {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.RevocationCheckAction =
      software.amazon.awssdk.services.networkfirewall.model.RevocationCheckAction.UNKNOWN_TO_SDK_VERSION
  }
  case object PASS extends zio.aws.networkfirewall.model.RevocationCheckAction {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.RevocationCheckAction =
      software.amazon.awssdk.services.networkfirewall.model.RevocationCheckAction.PASS
  }
  case object DROP extends zio.aws.networkfirewall.model.RevocationCheckAction {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.RevocationCheckAction =
      software.amazon.awssdk.services.networkfirewall.model.RevocationCheckAction.DROP
  }
  case object REJECT
      extends zio.aws.networkfirewall.model.RevocationCheckAction {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.RevocationCheckAction =
      software.amazon.awssdk.services.networkfirewall.model.RevocationCheckAction.REJECT
  }
}
