package zio.aws.networkfirewall.model
import scala.jdk.CollectionConverters.*
sealed trait IdentifiedType {
  def unwrap
      : software.amazon.awssdk.services.networkfirewall.model.IdentifiedType
}
object IdentifiedType {
  def wrap(
      value: software.amazon.awssdk.services.networkfirewall.model.IdentifiedType
  ): zio.aws.networkfirewall.model.IdentifiedType = value match {
    case software.amazon.awssdk.services.networkfirewall.model.IdentifiedType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.networkfirewall.model.IdentifiedType.STATELESS_RULE_FORWARDING_ASYMMETRICALLY =>
      val r = STATELESS_RULE_FORWARDING_ASYMMETRICALLY
      r
    case software.amazon.awssdk.services.networkfirewall.model.IdentifiedType.STATELESS_RULE_CONTAINS_TCP_FLAGS =>
      val r = STATELESS_RULE_CONTAINS_TCP_FLAGS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.networkfirewall.model.IdentifiedType {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.IdentifiedType =
      software.amazon.awssdk.services.networkfirewall.model.IdentifiedType.UNKNOWN_TO_SDK_VERSION
  }
  case object STATELESS_RULE_FORWARDING_ASYMMETRICALLY
      extends zio.aws.networkfirewall.model.IdentifiedType {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.IdentifiedType =
      software.amazon.awssdk.services.networkfirewall.model.IdentifiedType.STATELESS_RULE_FORWARDING_ASYMMETRICALLY
  }
  case object STATELESS_RULE_CONTAINS_TCP_FLAGS
      extends zio.aws.networkfirewall.model.IdentifiedType {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.IdentifiedType =
      software.amazon.awssdk.services.networkfirewall.model.IdentifiedType.STATELESS_RULE_CONTAINS_TCP_FLAGS
  }
}
