package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.networkfirewall.model.primitives.{
  ResourceArn,
  CollectionMember_String
}
import scala.jdk.CollectionConverters.*
final case class FirewallPolicy(
    statelessRuleGroupReferences: Optional[
      Iterable[zio.aws.networkfirewall.model.StatelessRuleGroupReference]
    ] = Optional.Absent,
    statelessDefaultActions: Iterable[CollectionMember_String],
    statelessFragmentDefaultActions: Iterable[CollectionMember_String],
    statelessCustomActions: Optional[
      Iterable[zio.aws.networkfirewall.model.CustomAction]
    ] = Optional.Absent,
    statefulRuleGroupReferences: Optional[
      Iterable[zio.aws.networkfirewall.model.StatefulRuleGroupReference]
    ] = Optional.Absent,
    statefulDefaultActions: Optional[Iterable[CollectionMember_String]] =
      Optional.Absent,
    statefulEngineOptions: Optional[
      zio.aws.networkfirewall.model.StatefulEngineOptions
    ] = Optional.Absent,
    tlsInspectionConfigurationArn: Optional[ResourceArn] = Optional.Absent,
    policyVariables: Optional[zio.aws.networkfirewall.model.PolicyVariables] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.FirewallPolicy = {
    import FirewallPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.FirewallPolicy
      .builder()
      .optionallyWith(
        statelessRuleGroupReferences.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.statelessRuleGroupReferences)
      .statelessDefaultActions(statelessDefaultActions.map { item =>
        CollectionMember_String.unwrap(item): java.lang.String
      }.asJavaCollection)
      .statelessFragmentDefaultActions(statelessFragmentDefaultActions.map {
        item =>
          CollectionMember_String.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        statelessCustomActions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.statelessCustomActions)
      .optionallyWith(
        statefulRuleGroupReferences.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.statefulRuleGroupReferences)
      .optionallyWith(
        statefulDefaultActions.map(value =>
          value.map { item =>
            CollectionMember_String.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.statefulDefaultActions)
      .optionallyWith(
        statefulEngineOptions.map(value => value.buildAwsValue())
      )(_.statefulEngineOptions)
      .optionallyWith(
        tlsInspectionConfigurationArn.map(value =>
          ResourceArn.unwrap(value): java.lang.String
        )
      )(_.tlsInspectionConfigurationArn)
      .optionallyWith(policyVariables.map(value => value.buildAwsValue()))(
        _.policyVariables
      )
      .build()
  }
  def asReadOnly: zio.aws.networkfirewall.model.FirewallPolicy.ReadOnly =
    zio.aws.networkfirewall.model.FirewallPolicy.wrap(buildAwsValue())
}
object FirewallPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.FirewallPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.FirewallPolicy =
      zio.aws.networkfirewall.model.FirewallPolicy(
        statelessRuleGroupReferences.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        statelessDefaultActions,
        statelessFragmentDefaultActions,
        statelessCustomActions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        statefulRuleGroupReferences.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        statefulDefaultActions.map(value => value),
        statefulEngineOptions.map(value => value.asEditable),
        tlsInspectionConfigurationArn.map(value => value),
        policyVariables.map(value => value.asEditable)
      )
    def statelessRuleGroupReferences: Optional[
      List[zio.aws.networkfirewall.model.StatelessRuleGroupReference.ReadOnly]
    ]
    def statelessDefaultActions: List[CollectionMember_String]
    def statelessFragmentDefaultActions: List[CollectionMember_String]
    def statelessCustomActions
        : Optional[List[zio.aws.networkfirewall.model.CustomAction.ReadOnly]]
    def statefulRuleGroupReferences: Optional[
      List[zio.aws.networkfirewall.model.StatefulRuleGroupReference.ReadOnly]
    ]
    def statefulDefaultActions: Optional[List[CollectionMember_String]]
    def statefulEngineOptions
        : Optional[zio.aws.networkfirewall.model.StatefulEngineOptions.ReadOnly]
    def tlsInspectionConfigurationArn: Optional[ResourceArn]
    def policyVariables
        : Optional[zio.aws.networkfirewall.model.PolicyVariables.ReadOnly]
    def getStatelessRuleGroupReferences: ZIO[Any, AwsError, List[
      zio.aws.networkfirewall.model.StatelessRuleGroupReference.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "statelessRuleGroupReferences",
      statelessRuleGroupReferences
    )
    def getStatelessDefaultActions
        : ZIO[Any, Nothing, List[CollectionMember_String]] =
      ZIO.succeed(statelessDefaultActions)
    def getStatelessFragmentDefaultActions
        : ZIO[Any, Nothing, List[CollectionMember_String]] =
      ZIO.succeed(statelessFragmentDefaultActions)
    def getStatelessCustomActions: ZIO[Any, AwsError, List[
      zio.aws.networkfirewall.model.CustomAction.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "statelessCustomActions",
      statelessCustomActions
    )
    def getStatefulRuleGroupReferences: ZIO[Any, AwsError, List[
      zio.aws.networkfirewall.model.StatefulRuleGroupReference.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "statefulRuleGroupReferences",
      statefulRuleGroupReferences
    )
    def getStatefulDefaultActions
        : ZIO[Any, AwsError, List[CollectionMember_String]] = AwsError
      .unwrapOptionField("statefulDefaultActions", statefulDefaultActions)
    def getStatefulEngineOptions: ZIO[
      Any,
      AwsError,
      zio.aws.networkfirewall.model.StatefulEngineOptions.ReadOnly
    ] =
      AwsError.unwrapOptionField("statefulEngineOptions", statefulEngineOptions)
    def getTlsInspectionConfigurationArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField(
        "tlsInspectionConfigurationArn",
        tlsInspectionConfigurationArn
      )
    def getPolicyVariables: ZIO[
      Any,
      AwsError,
      zio.aws.networkfirewall.model.PolicyVariables.ReadOnly
    ] = AwsError.unwrapOptionField("policyVariables", policyVariables)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.FirewallPolicy
  ) extends zio.aws.networkfirewall.model.FirewallPolicy.ReadOnly {
    override val statelessRuleGroupReferences: Optional[
      List[zio.aws.networkfirewall.model.StatelessRuleGroupReference.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.statelessRuleGroupReferences())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.networkfirewall.model.StatelessRuleGroupReference.wrap(item)
        }.toList
      )
    override val statelessDefaultActions: List[CollectionMember_String] = impl
      .statelessDefaultActions()
      .asScala
      .map { item =>
        zio.aws.networkfirewall.model.primitives.CollectionMember_String(item)
      }
      .toList
    override val statelessFragmentDefaultActions
        : List[CollectionMember_String] = impl
      .statelessFragmentDefaultActions()
      .asScala
      .map { item =>
        zio.aws.networkfirewall.model.primitives.CollectionMember_String(item)
      }
      .toList
    override val statelessCustomActions
        : Optional[List[zio.aws.networkfirewall.model.CustomAction.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statelessCustomActions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkfirewall.model.CustomAction.wrap(item)
          }.toList
        )
    override val statefulRuleGroupReferences: Optional[
      List[zio.aws.networkfirewall.model.StatefulRuleGroupReference.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.statefulRuleGroupReferences())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.networkfirewall.model.StatefulRuleGroupReference.wrap(item)
        }.toList
      )
    override val statefulDefaultActions
        : Optional[List[CollectionMember_String]] = zio.aws.core.internal
      .optionalFromNullable(impl.statefulDefaultActions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.networkfirewall.model.primitives.CollectionMember_String(item)
        }.toList
      )
    override val statefulEngineOptions: Optional[
      zio.aws.networkfirewall.model.StatefulEngineOptions.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.statefulEngineOptions())
      .map(value =>
        zio.aws.networkfirewall.model.StatefulEngineOptions.wrap(value)
      )
    override val tlsInspectionConfigurationArn: Optional[ResourceArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tlsInspectionConfigurationArn())
        .map(value =>
          zio.aws.networkfirewall.model.primitives.ResourceArn(value)
        )
    override val policyVariables
        : Optional[zio.aws.networkfirewall.model.PolicyVariables.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policyVariables())
        .map(value => zio.aws.networkfirewall.model.PolicyVariables.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.FirewallPolicy
  ): zio.aws.networkfirewall.model.FirewallPolicy.ReadOnly = new Wrapper(impl)
}
