package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.networkfirewall.model.primitives.CollectionMember_String
import scala.jdk.CollectionConverters.*
final case class AnalysisResult(
    identifiedRuleIds: Optional[Iterable[CollectionMember_String]] =
      Optional.Absent,
    identifiedType: Optional[zio.aws.networkfirewall.model.IdentifiedType] =
      Optional.Absent,
    analysisDetail: Optional[CollectionMember_String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.AnalysisResult = {
    import AnalysisResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.AnalysisResult
      .builder()
      .optionallyWith(
        identifiedRuleIds.map(value =>
          value.map { item =>
            CollectionMember_String.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.identifiedRuleIds)
      .optionallyWith(identifiedType.map(value => value.unwrap))(
        _.identifiedType
      )
      .optionallyWith(
        analysisDetail.map(value =>
          CollectionMember_String.unwrap(value): java.lang.String
        )
      )(_.analysisDetail)
      .build()
  }
  def asReadOnly: zio.aws.networkfirewall.model.AnalysisResult.ReadOnly =
    zio.aws.networkfirewall.model.AnalysisResult.wrap(buildAwsValue())
}
object AnalysisResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.AnalysisResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.AnalysisResult =
      zio.aws.networkfirewall.model.AnalysisResult(
        identifiedRuleIds.map(value => value),
        identifiedType.map(value => value),
        analysisDetail.map(value => value)
      )
    def identifiedRuleIds: Optional[List[CollectionMember_String]]
    def identifiedType: Optional[zio.aws.networkfirewall.model.IdentifiedType]
    def analysisDetail: Optional[CollectionMember_String]
    def getIdentifiedRuleIds
        : ZIO[Any, AwsError, List[CollectionMember_String]] =
      AwsError.unwrapOptionField("identifiedRuleIds", identifiedRuleIds)
    def getIdentifiedType
        : ZIO[Any, AwsError, zio.aws.networkfirewall.model.IdentifiedType] =
      AwsError.unwrapOptionField("identifiedType", identifiedType)
    def getAnalysisDetail: ZIO[Any, AwsError, CollectionMember_String] =
      AwsError.unwrapOptionField("analysisDetail", analysisDetail)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.AnalysisResult
  ) extends zio.aws.networkfirewall.model.AnalysisResult.ReadOnly {
    override val identifiedRuleIds: Optional[List[CollectionMember_String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.identifiedRuleIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkfirewall.model.primitives
              .CollectionMember_String(item)
          }.toList
        )
    override val identifiedType
        : Optional[zio.aws.networkfirewall.model.IdentifiedType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.identifiedType())
        .map(value => zio.aws.networkfirewall.model.IdentifiedType.wrap(value))
    override val analysisDetail: Optional[CollectionMember_String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.analysisDetail())
        .map(value =>
          zio.aws.networkfirewall.model.primitives
            .CollectionMember_String(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.AnalysisResult
  ): zio.aws.networkfirewall.model.AnalysisResult.ReadOnly = new Wrapper(impl)
}
