package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.networkfirewall.model.primitives.{
  StatusReason,
  CollectionMember_String,
  ResourceArn
}
import scala.jdk.CollectionConverters.*
final case class TlsCertificateData(
    certificateArn: Optional[ResourceArn] = Optional.Absent,
    certificateSerial: Optional[CollectionMember_String] = Optional.Absent,
    status: Optional[CollectionMember_String] = Optional.Absent,
    statusMessage: Optional[StatusReason] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.TlsCertificateData = {
    import TlsCertificateData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.TlsCertificateData
      .builder()
      .optionallyWith(
        certificateArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.certificateArn)
      .optionallyWith(
        certificateSerial.map(value =>
          CollectionMember_String.unwrap(value): java.lang.String
        )
      )(_.certificateSerial)
      .optionallyWith(
        status.map(value =>
          CollectionMember_String.unwrap(value): java.lang.String
        )
      )(_.status)
      .optionallyWith(
        statusMessage.map(value => StatusReason.unwrap(value): java.lang.String)
      )(_.statusMessage)
      .build()
  }
  def asReadOnly: zio.aws.networkfirewall.model.TlsCertificateData.ReadOnly =
    zio.aws.networkfirewall.model.TlsCertificateData.wrap(buildAwsValue())
}
object TlsCertificateData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.TlsCertificateData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.TlsCertificateData =
      zio.aws.networkfirewall.model.TlsCertificateData(
        certificateArn.map(value => value),
        certificateSerial.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value)
      )
    def certificateArn: Optional[ResourceArn]
    def certificateSerial: Optional[CollectionMember_String]
    def status: Optional[CollectionMember_String]
    def statusMessage: Optional[StatusReason]
    def getCertificateArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("certificateArn", certificateArn)
    def getCertificateSerial: ZIO[Any, AwsError, CollectionMember_String] =
      AwsError.unwrapOptionField("certificateSerial", certificateSerial)
    def getStatus: ZIO[Any, AwsError, CollectionMember_String] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, StatusReason] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.TlsCertificateData
  ) extends zio.aws.networkfirewall.model.TlsCertificateData.ReadOnly {
    override val certificateArn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.certificateArn())
      .map(value => zio.aws.networkfirewall.model.primitives.ResourceArn(value))
    override val certificateSerial: Optional[CollectionMember_String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateSerial())
        .map(value =>
          zio.aws.networkfirewall.model.primitives
            .CollectionMember_String(value)
        )
    override val status: Optional[CollectionMember_String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.networkfirewall.model.primitives
            .CollectionMember_String(value)
        )
    override val statusMessage: Optional[StatusReason] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value =>
        zio.aws.networkfirewall.model.primitives.StatusReason(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.TlsCertificateData
  ): zio.aws.networkfirewall.model.TlsCertificateData.ReadOnly = new Wrapper(
    impl
  )
}
