package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.networkfirewall.model.primitives.{ResourceArn, ResourceName}
import scala.jdk.CollectionConverters.*
final case class TLSInspectionConfigurationMetadata(
    name: Optional[ResourceName] = Optional.Absent,
    arn: Optional[ResourceArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.TLSInspectionConfigurationMetadata = {
    import TLSInspectionConfigurationMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.TLSInspectionConfigurationMetadata
      .builder()
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        arn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.arn)
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.TLSInspectionConfigurationMetadata.ReadOnly =
    zio.aws.networkfirewall.model.TLSInspectionConfigurationMetadata
      .wrap(buildAwsValue())
}
object TLSInspectionConfigurationMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.TLSInspectionConfigurationMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkfirewall.model.TLSInspectionConfigurationMetadata =
      zio.aws.networkfirewall.model.TLSInspectionConfigurationMetadata(
        name.map(value => value),
        arn.map(value => value)
      )
    def name: Optional[ResourceName]
    def arn: Optional[ResourceArn]
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.TLSInspectionConfigurationMetadata
  ) extends zio.aws.networkfirewall.model.TLSInspectionConfigurationMetadata.ReadOnly {
    override val name: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.networkfirewall.model.primitives.ResourceName(value)
      )
    override val arn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.networkfirewall.model.primitives.ResourceArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.TLSInspectionConfigurationMetadata
  ): zio.aws.networkfirewall.model.TLSInspectionConfigurationMetadata.ReadOnly =
    new Wrapper(impl)
}
