package zio.aws.networkfirewall.model
import scala.jdk.CollectionConverters.*
sealed trait StatefulAction {
  def unwrap
      : software.amazon.awssdk.services.networkfirewall.model.StatefulAction
}
object StatefulAction {
  def wrap(
      value: software.amazon.awssdk.services.networkfirewall.model.StatefulAction
  ): zio.aws.networkfirewall.model.StatefulAction = value match {
    case software.amazon.awssdk.services.networkfirewall.model.StatefulAction.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.networkfirewall.model.StatefulAction.PASS =>
      val r = PASS
      r
    case software.amazon.awssdk.services.networkfirewall.model.StatefulAction.DROP =>
      val r = DROP
      r
    case software.amazon.awssdk.services.networkfirewall.model.StatefulAction.ALERT =>
      val r = ALERT
      r
    case software.amazon.awssdk.services.networkfirewall.model.StatefulAction.REJECT =>
      val r = REJECT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.networkfirewall.model.StatefulAction {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.StatefulAction =
      software.amazon.awssdk.services.networkfirewall.model.StatefulAction.UNKNOWN_TO_SDK_VERSION
  }
  case object PASS extends zio.aws.networkfirewall.model.StatefulAction {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.StatefulAction =
      software.amazon.awssdk.services.networkfirewall.model.StatefulAction.PASS
  }
  case object DROP extends zio.aws.networkfirewall.model.StatefulAction {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.StatefulAction =
      software.amazon.awssdk.services.networkfirewall.model.StatefulAction.DROP
  }
  case object ALERT extends zio.aws.networkfirewall.model.StatefulAction {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.StatefulAction =
      software.amazon.awssdk.services.networkfirewall.model.StatefulAction.ALERT
  }
  case object REJECT extends zio.aws.networkfirewall.model.StatefulAction {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.StatefulAction =
      software.amazon.awssdk.services.networkfirewall.model.StatefulAction.REJECT
  }
}
