package zio.aws.networkfirewall.model
import scala.jdk.CollectionConverters.*
sealed trait ResourceManagedStatus {
  def unwrap: software.amazon.awssdk.services.networkfirewall.model.ResourceManagedStatus
}
object ResourceManagedStatus {
  def wrap(
      value: software.amazon.awssdk.services.networkfirewall.model.ResourceManagedStatus
  ): zio.aws.networkfirewall.model.ResourceManagedStatus = value match {
    case software.amazon.awssdk.services.networkfirewall.model.ResourceManagedStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.networkfirewall.model.ResourceManagedStatus.MANAGED =>
      val r = MANAGED
      r
    case software.amazon.awssdk.services.networkfirewall.model.ResourceManagedStatus.ACCOUNT =>
      val r = ACCOUNT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.networkfirewall.model.ResourceManagedStatus {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.ResourceManagedStatus =
      software.amazon.awssdk.services.networkfirewall.model.ResourceManagedStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object MANAGED
      extends zio.aws.networkfirewall.model.ResourceManagedStatus {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.ResourceManagedStatus =
      software.amazon.awssdk.services.networkfirewall.model.ResourceManagedStatus.MANAGED
  }
  case object ACCOUNT
      extends zio.aws.networkfirewall.model.ResourceManagedStatus {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.ResourceManagedStatus =
      software.amazon.awssdk.services.networkfirewall.model.ResourceManagedStatus.ACCOUNT
  }
}
