package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.networkfirewall.model.primitives.IPSetReferenceName
import scala.jdk.CollectionConverters.*
final case class ReferenceSets(
    ipSetReferences: Optional[
      Map[IPSetReferenceName, zio.aws.networkfirewall.model.IPSetReference]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.ReferenceSets = {
    import ReferenceSets.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.ReferenceSets
      .builder()
      .optionallyWith(
        ipSetReferences.map(value =>
          value
            .map({ case (key, value) =>
              (IPSetReferenceName.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.ipSetReferences)
      .build()
  }
  def asReadOnly: zio.aws.networkfirewall.model.ReferenceSets.ReadOnly =
    zio.aws.networkfirewall.model.ReferenceSets.wrap(buildAwsValue())
}
object ReferenceSets {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.ReferenceSets
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.ReferenceSets =
      zio.aws.networkfirewall.model.ReferenceSets(
        ipSetReferences.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def ipSetReferences: Optional[Map[
      IPSetReferenceName,
      zio.aws.networkfirewall.model.IPSetReference.ReadOnly
    ]]
    def getIpSetReferences: ZIO[Any, AwsError, Map[
      IPSetReferenceName,
      zio.aws.networkfirewall.model.IPSetReference.ReadOnly
    ]] = AwsError.unwrapOptionField("ipSetReferences", ipSetReferences)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.ReferenceSets
  ) extends zio.aws.networkfirewall.model.ReferenceSets.ReadOnly {
    override val ipSetReferences: Optional[Map[
      IPSetReferenceName,
      zio.aws.networkfirewall.model.IPSetReference.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.ipSetReferences())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.networkfirewall.model.primitives.IPSetReferenceName(
              key
            ) -> zio.aws.networkfirewall.model.IPSetReference.wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.ReferenceSets
  ): zio.aws.networkfirewall.model.ReferenceSets.ReadOnly = new Wrapper(impl)
}
