package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.networkfirewall.model.primitives.{HashMapValue, HashMapKey}
import scala.jdk.CollectionConverters.*
final case class LogDestinationConfig(
    logType: zio.aws.networkfirewall.model.LogType,
    logDestinationType: zio.aws.networkfirewall.model.LogDestinationType,
    logDestination: Map[HashMapKey, HashMapValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.LogDestinationConfig = {
    import LogDestinationConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.LogDestinationConfig
      .builder()
      .logType(logType.unwrap)
      .logDestinationType(logDestinationType.unwrap)
      .logDestination(
        logDestination
          .map({ case (key, value) =>
            (HashMapKey.unwrap(key): java.lang.String) -> (HashMapValue
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.networkfirewall.model.LogDestinationConfig.ReadOnly =
    zio.aws.networkfirewall.model.LogDestinationConfig.wrap(buildAwsValue())
}
object LogDestinationConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.LogDestinationConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.LogDestinationConfig =
      zio.aws.networkfirewall.model
        .LogDestinationConfig(logType, logDestinationType, logDestination)
    def logType: zio.aws.networkfirewall.model.LogType
    def logDestinationType: zio.aws.networkfirewall.model.LogDestinationType
    def logDestination: Map[HashMapKey, HashMapValue]
    def getLogType: ZIO[Any, Nothing, zio.aws.networkfirewall.model.LogType] =
      ZIO.succeed(logType)
    def getLogDestinationType
        : ZIO[Any, Nothing, zio.aws.networkfirewall.model.LogDestinationType] =
      ZIO.succeed(logDestinationType)
    def getLogDestination: ZIO[Any, Nothing, Map[HashMapKey, HashMapValue]] =
      ZIO.succeed(logDestination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.LogDestinationConfig
  ) extends zio.aws.networkfirewall.model.LogDestinationConfig.ReadOnly {
    override val logType: zio.aws.networkfirewall.model.LogType =
      zio.aws.networkfirewall.model.LogType.wrap(impl.logType())
    override val logDestinationType
        : zio.aws.networkfirewall.model.LogDestinationType =
      zio.aws.networkfirewall.model.LogDestinationType
        .wrap(impl.logDestinationType())
    override val logDestination: Map[HashMapKey, HashMapValue] = impl
      .logDestination()
      .asScala
      .map({ case (key, value) =>
        zio.aws.networkfirewall.model.primitives.HashMapKey(
          key
        ) -> zio.aws.networkfirewall.model.primitives.HashMapValue(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.LogDestinationConfig
  ): zio.aws.networkfirewall.model.LogDestinationConfig.ReadOnly = new Wrapper(
    impl
  )
}
