package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.networkfirewall.model.primitives.UpdateToken
import scala.jdk.CollectionConverters.*
final case class DescribeTlsInspectionConfigurationResponse(
    updateToken: UpdateToken,
    tlsInspectionConfiguration: Optional[
      zio.aws.networkfirewall.model.TLSInspectionConfiguration
    ] = Optional.Absent,
    tlsInspectionConfigurationResponse: zio.aws.networkfirewall.model.TLSInspectionConfigurationResponse
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.DescribeTlsInspectionConfigurationResponse = {
    import DescribeTlsInspectionConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.DescribeTlsInspectionConfigurationResponse
      .builder()
      .updateToken(UpdateToken.unwrap(updateToken): java.lang.String)
      .optionallyWith(
        tlsInspectionConfiguration.map(value => value.buildAwsValue())
      )(_.tlsInspectionConfiguration)
      .tlsInspectionConfigurationResponse(
        tlsInspectionConfigurationResponse.buildAwsValue()
      )
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.DescribeTlsInspectionConfigurationResponse.ReadOnly =
    zio.aws.networkfirewall.model.DescribeTlsInspectionConfigurationResponse
      .wrap(buildAwsValue())
}
object DescribeTlsInspectionConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.DescribeTlsInspectionConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkfirewall.model.DescribeTlsInspectionConfigurationResponse =
      zio.aws.networkfirewall.model.DescribeTlsInspectionConfigurationResponse(
        updateToken,
        tlsInspectionConfiguration.map(value => value.asEditable),
        tlsInspectionConfigurationResponse.asEditable
      )
    def updateToken: UpdateToken
    def tlsInspectionConfiguration: Optional[
      zio.aws.networkfirewall.model.TLSInspectionConfiguration.ReadOnly
    ]
    def tlsInspectionConfigurationResponse
        : zio.aws.networkfirewall.model.TLSInspectionConfigurationResponse.ReadOnly
    def getUpdateToken: ZIO[Any, Nothing, UpdateToken] =
      ZIO.succeed(updateToken)
    def getTlsInspectionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.networkfirewall.model.TLSInspectionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "tlsInspectionConfiguration",
      tlsInspectionConfiguration
    )
    def getTlsInspectionConfigurationResponse: ZIO[
      Any,
      Nothing,
      zio.aws.networkfirewall.model.TLSInspectionConfigurationResponse.ReadOnly
    ] = ZIO.succeed(tlsInspectionConfigurationResponse)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.DescribeTlsInspectionConfigurationResponse
  ) extends zio.aws.networkfirewall.model.DescribeTlsInspectionConfigurationResponse.ReadOnly {
    override val updateToken: UpdateToken =
      zio.aws.networkfirewall.model.primitives.UpdateToken(impl.updateToken())
    override val tlsInspectionConfiguration: Optional[
      zio.aws.networkfirewall.model.TLSInspectionConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.tlsInspectionConfiguration())
      .map(value =>
        zio.aws.networkfirewall.model.TLSInspectionConfiguration.wrap(value)
      )
    override val tlsInspectionConfigurationResponse
        : zio.aws.networkfirewall.model.TLSInspectionConfigurationResponse.ReadOnly =
      zio.aws.networkfirewall.model.TLSInspectionConfigurationResponse
        .wrap(impl.tlsInspectionConfigurationResponse())
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.DescribeTlsInspectionConfigurationResponse
  ): zio.aws.networkfirewall.model.DescribeTlsInspectionConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
