package zio.aws.networkfirewall.model
import zio.aws.networkfirewall.model.primitives.{
  Description,
  ResourceArn,
  NumberOfAssociations,
  LastUpdateTime,
  ResourceId,
  ResourceName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class TLSInspectionConfigurationResponse(
    tlsInspectionConfigurationArn: ResourceArn,
    tlsInspectionConfigurationName: ResourceName,
    tlsInspectionConfigurationId: ResourceId,
    tlsInspectionConfigurationStatus: Optional[
      zio.aws.networkfirewall.model.ResourceStatus
    ] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.networkfirewall.model.Tag]] =
      Optional.Absent,
    lastModifiedTime: Optional[LastUpdateTime] = Optional.Absent,
    numberOfAssociations: Optional[NumberOfAssociations] = Optional.Absent,
    encryptionConfiguration: Optional[
      zio.aws.networkfirewall.model.EncryptionConfiguration
    ] = Optional.Absent,
    certificates: Optional[
      Iterable[zio.aws.networkfirewall.model.TlsCertificateData]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.TLSInspectionConfigurationResponse = {
    import TLSInspectionConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.TLSInspectionConfigurationResponse
      .builder()
      .tlsInspectionConfigurationArn(
        ResourceArn.unwrap(tlsInspectionConfigurationArn): java.lang.String
      )
      .tlsInspectionConfigurationName(
        ResourceName.unwrap(tlsInspectionConfigurationName): java.lang.String
      )
      .tlsInspectionConfigurationId(
        ResourceId.unwrap(tlsInspectionConfigurationId): java.lang.String
      )
      .optionallyWith(
        tlsInspectionConfigurationStatus.map(value => value.unwrap)
      )(_.tlsInspectionConfigurationStatus)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        lastModifiedTime.map(value => LastUpdateTime.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(
        numberOfAssociations.map(value =>
          NumberOfAssociations.unwrap(value): Integer
        )
      )(_.numberOfAssociations)
      .optionallyWith(
        encryptionConfiguration.map(value => value.buildAwsValue())
      )(_.encryptionConfiguration)
      .optionallyWith(
        certificates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.certificates)
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.TLSInspectionConfigurationResponse.ReadOnly =
    zio.aws.networkfirewall.model.TLSInspectionConfigurationResponse
      .wrap(buildAwsValue())
}
object TLSInspectionConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.TLSInspectionConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkfirewall.model.TLSInspectionConfigurationResponse =
      zio.aws.networkfirewall.model.TLSInspectionConfigurationResponse(
        tlsInspectionConfigurationArn,
        tlsInspectionConfigurationName,
        tlsInspectionConfigurationId,
        tlsInspectionConfigurationStatus.map(value => value),
        description.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lastModifiedTime.map(value => value),
        numberOfAssociations.map(value => value),
        encryptionConfiguration.map(value => value.asEditable),
        certificates.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def tlsInspectionConfigurationArn: ResourceArn
    def tlsInspectionConfigurationName: ResourceName
    def tlsInspectionConfigurationId: ResourceId
    def tlsInspectionConfigurationStatus
        : Optional[zio.aws.networkfirewall.model.ResourceStatus]
    def description: Optional[Description]
    def tags: Optional[List[zio.aws.networkfirewall.model.Tag.ReadOnly]]
    def lastModifiedTime: Optional[LastUpdateTime]
    def numberOfAssociations: Optional[NumberOfAssociations]
    def encryptionConfiguration: Optional[
      zio.aws.networkfirewall.model.EncryptionConfiguration.ReadOnly
    ]
    def certificates: Optional[
      List[zio.aws.networkfirewall.model.TlsCertificateData.ReadOnly]
    ]
    def getTlsInspectionConfigurationArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(tlsInspectionConfigurationArn)
    def getTlsInspectionConfigurationName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(tlsInspectionConfigurationName)
    def getTlsInspectionConfigurationId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(tlsInspectionConfigurationId)
    def getTlsInspectionConfigurationStatus
        : ZIO[Any, AwsError, zio.aws.networkfirewall.model.ResourceStatus] =
      AwsError.unwrapOptionField(
        "tlsInspectionConfigurationStatus",
        tlsInspectionConfigurationStatus
      )
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.networkfirewall.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getLastModifiedTime: ZIO[Any, AwsError, LastUpdateTime] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getNumberOfAssociations: ZIO[Any, AwsError, NumberOfAssociations] =
      AwsError.unwrapOptionField("numberOfAssociations", numberOfAssociations)
    def getEncryptionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.networkfirewall.model.EncryptionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "encryptionConfiguration",
      encryptionConfiguration
    )
    def getCertificates: ZIO[Any, AwsError, List[
      zio.aws.networkfirewall.model.TlsCertificateData.ReadOnly
    ]] = AwsError.unwrapOptionField("certificates", certificates)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.TLSInspectionConfigurationResponse
  ) extends zio.aws.networkfirewall.model.TLSInspectionConfigurationResponse.ReadOnly {
    override val tlsInspectionConfigurationArn: ResourceArn =
      zio.aws.networkfirewall.model.primitives
        .ResourceArn(impl.tlsInspectionConfigurationArn())
    override val tlsInspectionConfigurationName: ResourceName =
      zio.aws.networkfirewall.model.primitives
        .ResourceName(impl.tlsInspectionConfigurationName())
    override val tlsInspectionConfigurationId: ResourceId =
      zio.aws.networkfirewall.model.primitives
        .ResourceId(impl.tlsInspectionConfigurationId())
    override val tlsInspectionConfigurationStatus
        : Optional[zio.aws.networkfirewall.model.ResourceStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tlsInspectionConfigurationStatus())
        .map(value => zio.aws.networkfirewall.model.ResourceStatus.wrap(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.networkfirewall.model.primitives.Description(value))
    override val tags
        : Optional[List[zio.aws.networkfirewall.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkfirewall.model.Tag.wrap(item)
          }.toList
        )
    override val lastModifiedTime: Optional[LastUpdateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedTime())
        .map(value =>
          zio.aws.networkfirewall.model.primitives.LastUpdateTime(value)
        )
    override val numberOfAssociations: Optional[NumberOfAssociations] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numberOfAssociations())
        .map(value =>
          zio.aws.networkfirewall.model.primitives.NumberOfAssociations(value)
        )
    override val encryptionConfiguration: Optional[
      zio.aws.networkfirewall.model.EncryptionConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.encryptionConfiguration())
      .map(value =>
        zio.aws.networkfirewall.model.EncryptionConfiguration.wrap(value)
      )
    override val certificates: Optional[
      List[zio.aws.networkfirewall.model.TlsCertificateData.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.certificates())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.networkfirewall.model.TlsCertificateData.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.TLSInspectionConfigurationResponse
  ): zio.aws.networkfirewall.model.TLSInspectionConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
