package zio.aws.networkfirewall.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.networkfirewall.model.primitives.{Priority, ResourceArn}
import scala.jdk.CollectionConverters.*
final case class StatelessRuleGroupReference(
    resourceArn: ResourceArn,
    priority: Priority
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.StatelessRuleGroupReference = {
    import StatelessRuleGroupReference.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.StatelessRuleGroupReference
      .builder()
      .resourceArn(ResourceArn.unwrap(resourceArn): java.lang.String)
      .priority(Priority.unwrap(priority): Integer)
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.StatelessRuleGroupReference.ReadOnly =
    zio.aws.networkfirewall.model.StatelessRuleGroupReference
      .wrap(buildAwsValue())
}
object StatelessRuleGroupReference {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.StatelessRuleGroupReference
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.StatelessRuleGroupReference =
      zio.aws.networkfirewall.model
        .StatelessRuleGroupReference(resourceArn, priority)
    def resourceArn: ResourceArn
    def priority: Priority
    def getResourceArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceArn)
    def getPriority: ZIO[Any, Nothing, Priority] = ZIO.succeed(priority)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.StatelessRuleGroupReference
  ) extends zio.aws.networkfirewall.model.StatelessRuleGroupReference.ReadOnly {
    override val resourceArn: ResourceArn =
      zio.aws.networkfirewall.model.primitives.ResourceArn(impl.resourceArn())
    override val priority: Priority =
      zio.aws.networkfirewall.model.primitives.Priority(impl.priority())
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.StatelessRuleGroupReference
  ): zio.aws.networkfirewall.model.StatelessRuleGroupReference.ReadOnly =
    new Wrapper(impl)
}
