package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class TLSInspectionConfiguration(
    serverCertificateConfigurations: Optional[
      Iterable[zio.aws.networkfirewall.model.ServerCertificateConfiguration]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.TLSInspectionConfiguration = {
    import TLSInspectionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.TLSInspectionConfiguration
      .builder()
      .optionallyWith(
        serverCertificateConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.serverCertificateConfigurations)
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.TLSInspectionConfiguration.ReadOnly =
    zio.aws.networkfirewall.model.TLSInspectionConfiguration
      .wrap(buildAwsValue())
}
object TLSInspectionConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.TLSInspectionConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.TLSInspectionConfiguration =
      zio.aws.networkfirewall.model.TLSInspectionConfiguration(
        serverCertificateConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def serverCertificateConfigurations: Optional[List[
      zio.aws.networkfirewall.model.ServerCertificateConfiguration.ReadOnly
    ]]
    def getServerCertificateConfigurations: ZIO[Any, AwsError, List[
      zio.aws.networkfirewall.model.ServerCertificateConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "serverCertificateConfigurations",
      serverCertificateConfigurations
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.TLSInspectionConfiguration
  ) extends zio.aws.networkfirewall.model.TLSInspectionConfiguration.ReadOnly {
    override val serverCertificateConfigurations: Optional[List[
      zio.aws.networkfirewall.model.ServerCertificateConfiguration.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.serverCertificateConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.networkfirewall.model.ServerCertificateConfiguration
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.TLSInspectionConfiguration
  ): zio.aws.networkfirewall.model.TLSInspectionConfiguration.ReadOnly =
    new Wrapper(impl)
}
