package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.networkfirewall.model.primitives.RuleVariableName
import scala.jdk.CollectionConverters.*
final case class PolicyVariables(
    ruleVariables: Optional[
      Map[RuleVariableName, zio.aws.networkfirewall.model.IPSet]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.PolicyVariables = {
    import PolicyVariables.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.PolicyVariables
      .builder()
      .optionallyWith(
        ruleVariables.map(value =>
          value
            .map({ case (key, value) =>
              (RuleVariableName.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.ruleVariables)
      .build()
  }
  def asReadOnly: zio.aws.networkfirewall.model.PolicyVariables.ReadOnly =
    zio.aws.networkfirewall.model.PolicyVariables.wrap(buildAwsValue())
}
object PolicyVariables {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.PolicyVariables
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.PolicyVariables =
      zio.aws.networkfirewall.model.PolicyVariables(
        ruleVariables.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def ruleVariables: Optional[
      Map[RuleVariableName, zio.aws.networkfirewall.model.IPSet.ReadOnly]
    ]
    def getRuleVariables: ZIO[Any, AwsError, Map[
      RuleVariableName,
      zio.aws.networkfirewall.model.IPSet.ReadOnly
    ]] = AwsError.unwrapOptionField("ruleVariables", ruleVariables)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.PolicyVariables
  ) extends zio.aws.networkfirewall.model.PolicyVariables.ReadOnly {
    override val ruleVariables: Optional[
      Map[RuleVariableName, zio.aws.networkfirewall.model.IPSet.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleVariables())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.networkfirewall.model.primitives.RuleVariableName(
              key
            ) -> zio.aws.networkfirewall.model.IPSet.wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.PolicyVariables
  ): zio.aws.networkfirewall.model.PolicyVariables.ReadOnly = new Wrapper(impl)
}
