package zio.aws.networkfirewall.model
import scala.jdk.CollectionConverters.*
sealed trait LogType {
  def unwrap: software.amazon.awssdk.services.networkfirewall.model.LogType
}
object LogType {
  def wrap(
      value: software.amazon.awssdk.services.networkfirewall.model.LogType
  ): zio.aws.networkfirewall.model.LogType = value match {
    case software.amazon.awssdk.services.networkfirewall.model.LogType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.networkfirewall.model.LogType.ALERT =>
      val r = ALERT
      r
    case software.amazon.awssdk.services.networkfirewall.model.LogType.FLOW =>
      val r = FLOW
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.networkfirewall.model.LogType {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.LogType =
      software.amazon.awssdk.services.networkfirewall.model.LogType.UNKNOWN_TO_SDK_VERSION
  }
  case object ALERT extends zio.aws.networkfirewall.model.LogType {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.LogType =
      software.amazon.awssdk.services.networkfirewall.model.LogType.ALERT
  }
  case object FLOW extends zio.aws.networkfirewall.model.LogType {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.LogType =
      software.amazon.awssdk.services.networkfirewall.model.LogType.FLOW
  }
}
