package zio.aws.networkfirewall.model
import zio.aws.networkfirewall.model.primitives.{
  PaginationMaxResults,
  PaginationToken
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListTlsInspectionConfigurationsRequest(
    nextToken: Optional[PaginationToken] = Optional.Absent,
    maxResults: Optional[PaginationMaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.ListTlsInspectionConfigurationsRequest = {
    import ListTlsInspectionConfigurationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.ListTlsInspectionConfigurationsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => PaginationMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.ListTlsInspectionConfigurationsRequest.ReadOnly =
    zio.aws.networkfirewall.model.ListTlsInspectionConfigurationsRequest
      .wrap(buildAwsValue())
}
object ListTlsInspectionConfigurationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.ListTlsInspectionConfigurationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkfirewall.model.ListTlsInspectionConfigurationsRequest =
      zio.aws.networkfirewall.model.ListTlsInspectionConfigurationsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Optional[PaginationToken]
    def maxResults: Optional[PaginationMaxResults]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, PaginationMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.ListTlsInspectionConfigurationsRequest
  ) extends zio.aws.networkfirewall.model.ListTlsInspectionConfigurationsRequest.ReadOnly {
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.networkfirewall.model.primitives.PaginationToken(value)
      )
    override val maxResults: Optional[PaginationMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.networkfirewall.model.primitives.PaginationMaxResults(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.ListTlsInspectionConfigurationsRequest
  ): zio.aws.networkfirewall.model.ListTlsInspectionConfigurationsRequest.ReadOnly =
    new Wrapper(impl)
}
