package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.networkfirewall.model.primitives.ResourceArn
import scala.jdk.CollectionConverters.*
final case class DeleteResourcePolicyRequest(resourceArn: ResourceArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.DeleteResourcePolicyRequest = {
    import DeleteResourcePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.DeleteResourcePolicyRequest
      .builder()
      .resourceArn(ResourceArn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.DeleteResourcePolicyRequest.ReadOnly =
    zio.aws.networkfirewall.model.DeleteResourcePolicyRequest
      .wrap(buildAwsValue())
}
object DeleteResourcePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.DeleteResourcePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.DeleteResourcePolicyRequest =
      zio.aws.networkfirewall.model.DeleteResourcePolicyRequest(resourceArn)
    def resourceArn: ResourceArn
    def getResourceArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.DeleteResourcePolicyRequest
  ) extends zio.aws.networkfirewall.model.DeleteResourcePolicyRequest.ReadOnly {
    override val resourceArn: ResourceArn =
      zio.aws.networkfirewall.model.primitives.ResourceArn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.DeleteResourcePolicyRequest
  ): zio.aws.networkfirewall.model.DeleteResourcePolicyRequest.ReadOnly =
    new Wrapper(impl)
}
