package zio.aws.networkfirewall.model
import scala.jdk.CollectionConverters.*
sealed trait StreamExceptionPolicy {
  def unwrap: software.amazon.awssdk.services.networkfirewall.model.StreamExceptionPolicy
}
object StreamExceptionPolicy {
  def wrap(
      value: software.amazon.awssdk.services.networkfirewall.model.StreamExceptionPolicy
  ): zio.aws.networkfirewall.model.StreamExceptionPolicy = value match {
    case software.amazon.awssdk.services.networkfirewall.model.StreamExceptionPolicy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.networkfirewall.model.StreamExceptionPolicy.DROP =>
      val r = DROP
      r
    case software.amazon.awssdk.services.networkfirewall.model.StreamExceptionPolicy.CONTINUE =>
      val r = CONTINUE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.networkfirewall.model.StreamExceptionPolicy {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.StreamExceptionPolicy =
      software.amazon.awssdk.services.networkfirewall.model.StreamExceptionPolicy.UNKNOWN_TO_SDK_VERSION
  }
  case object DROP extends zio.aws.networkfirewall.model.StreamExceptionPolicy {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.StreamExceptionPolicy =
      software.amazon.awssdk.services.networkfirewall.model.StreamExceptionPolicy.DROP
  }
  case object CONTINUE
      extends zio.aws.networkfirewall.model.StreamExceptionPolicy {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.StreamExceptionPolicy =
      software.amazon.awssdk.services.networkfirewall.model.StreamExceptionPolicy.CONTINUE
  }
}
