package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RuleGroup(
    ruleVariables: Optional[zio.aws.networkfirewall.model.RuleVariables] =
      Optional.Absent,
    referenceSets: Optional[zio.aws.networkfirewall.model.ReferenceSets] =
      Optional.Absent,
    rulesSource: zio.aws.networkfirewall.model.RulesSource,
    statefulRuleOptions: Optional[
      zio.aws.networkfirewall.model.StatefulRuleOptions
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.RuleGroup = {
    import RuleGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.RuleGroup
      .builder()
      .optionallyWith(ruleVariables.map(value => value.buildAwsValue()))(
        _.ruleVariables
      )
      .optionallyWith(referenceSets.map(value => value.buildAwsValue()))(
        _.referenceSets
      )
      .rulesSource(rulesSource.buildAwsValue())
      .optionallyWith(statefulRuleOptions.map(value => value.buildAwsValue()))(
        _.statefulRuleOptions
      )
      .build()
  }
  def asReadOnly: zio.aws.networkfirewall.model.RuleGroup.ReadOnly =
    zio.aws.networkfirewall.model.RuleGroup.wrap(buildAwsValue())
}
object RuleGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.RuleGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.RuleGroup =
      zio.aws.networkfirewall.model.RuleGroup(
        ruleVariables.map(value => value.asEditable),
        referenceSets.map(value => value.asEditable),
        rulesSource.asEditable,
        statefulRuleOptions.map(value => value.asEditable)
      )
    def ruleVariables
        : Optional[zio.aws.networkfirewall.model.RuleVariables.ReadOnly]
    def referenceSets
        : Optional[zio.aws.networkfirewall.model.ReferenceSets.ReadOnly]
    def rulesSource: zio.aws.networkfirewall.model.RulesSource.ReadOnly
    def statefulRuleOptions
        : Optional[zio.aws.networkfirewall.model.StatefulRuleOptions.ReadOnly]
    def getRuleVariables: ZIO[
      Any,
      AwsError,
      zio.aws.networkfirewall.model.RuleVariables.ReadOnly
    ] = AwsError.unwrapOptionField("ruleVariables", ruleVariables)
    def getReferenceSets: ZIO[
      Any,
      AwsError,
      zio.aws.networkfirewall.model.ReferenceSets.ReadOnly
    ] = AwsError.unwrapOptionField("referenceSets", referenceSets)
    def getRulesSource: ZIO[
      Any,
      Nothing,
      zio.aws.networkfirewall.model.RulesSource.ReadOnly
    ] = ZIO.succeed(rulesSource)
    def getStatefulRuleOptions: ZIO[
      Any,
      AwsError,
      zio.aws.networkfirewall.model.StatefulRuleOptions.ReadOnly
    ] = AwsError.unwrapOptionField("statefulRuleOptions", statefulRuleOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.RuleGroup
  ) extends zio.aws.networkfirewall.model.RuleGroup.ReadOnly {
    override val ruleVariables
        : Optional[zio.aws.networkfirewall.model.RuleVariables.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ruleVariables())
        .map(value => zio.aws.networkfirewall.model.RuleVariables.wrap(value))
    override val referenceSets
        : Optional[zio.aws.networkfirewall.model.ReferenceSets.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.referenceSets())
        .map(value => zio.aws.networkfirewall.model.ReferenceSets.wrap(value))
    override val rulesSource
        : zio.aws.networkfirewall.model.RulesSource.ReadOnly =
      zio.aws.networkfirewall.model.RulesSource.wrap(impl.rulesSource())
    override val statefulRuleOptions
        : Optional[zio.aws.networkfirewall.model.StatefulRuleOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statefulRuleOptions())
        .map(value =>
          zio.aws.networkfirewall.model.StatefulRuleOptions.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.RuleGroup
  ): zio.aws.networkfirewall.model.RuleGroup.ReadOnly = new Wrapper(impl)
}
