package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.networkfirewall.model.primitives.CollectionMember_String
import scala.jdk.CollectionConverters.*
final case class RulesSourceList(
    targets: Iterable[CollectionMember_String],
    targetTypes: Iterable[zio.aws.networkfirewall.model.TargetType],
    generatedRulesType: zio.aws.networkfirewall.model.GeneratedRulesType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.RulesSourceList = {
    import RulesSourceList.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.RulesSourceList
      .builder()
      .targets(targets.map { item =>
        CollectionMember_String.unwrap(item): java.lang.String
      }.asJavaCollection)
      .targetTypesWithStrings(targetTypes.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .generatedRulesType(generatedRulesType.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.networkfirewall.model.RulesSourceList.ReadOnly =
    zio.aws.networkfirewall.model.RulesSourceList.wrap(buildAwsValue())
}
object RulesSourceList {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.RulesSourceList
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.RulesSourceList =
      zio.aws.networkfirewall.model
        .RulesSourceList(targets, targetTypes, generatedRulesType)
    def targets: List[CollectionMember_String]
    def targetTypes: List[zio.aws.networkfirewall.model.TargetType]
    def generatedRulesType: zio.aws.networkfirewall.model.GeneratedRulesType
    def getTargets: ZIO[Any, Nothing, List[CollectionMember_String]] =
      ZIO.succeed(targets)
    def getTargetTypes
        : ZIO[Any, Nothing, List[zio.aws.networkfirewall.model.TargetType]] =
      ZIO.succeed(targetTypes)
    def getGeneratedRulesType
        : ZIO[Any, Nothing, zio.aws.networkfirewall.model.GeneratedRulesType] =
      ZIO.succeed(generatedRulesType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.RulesSourceList
  ) extends zio.aws.networkfirewall.model.RulesSourceList.ReadOnly {
    override val targets: List[CollectionMember_String] = impl
      .targets()
      .asScala
      .map { item =>
        zio.aws.networkfirewall.model.primitives.CollectionMember_String(item)
      }
      .toList
    override val targetTypes: List[zio.aws.networkfirewall.model.TargetType] =
      impl
        .targetTypes()
        .asScala
        .map { item =>
          zio.aws.networkfirewall.model.TargetType.wrap(item)
        }
        .toList
    override val generatedRulesType
        : zio.aws.networkfirewall.model.GeneratedRulesType =
      zio.aws.networkfirewall.model.GeneratedRulesType
        .wrap(impl.generatedRulesType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.RulesSourceList
  ): zio.aws.networkfirewall.model.RulesSourceList.ReadOnly = new Wrapper(impl)
}
