package zio.aws.networkfirewall.model
import zio.aws.networkfirewall.model.primitives.{IPSetArn, CIDRCount}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CIDRSummary(
    availableCIDRCount: Optional[CIDRCount] = Optional.Absent,
    utilizedCIDRCount: Optional[CIDRCount] = Optional.Absent,
    ipSetReferences: Optional[
      Map[IPSetArn, zio.aws.networkfirewall.model.IPSetMetadata]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.CIDRSummary = {
    import CIDRSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.CIDRSummary
      .builder()
      .optionallyWith(
        availableCIDRCount.map(value => CIDRCount.unwrap(value): Integer)
      )(_.availableCIDRCount)
      .optionallyWith(
        utilizedCIDRCount.map(value => CIDRCount.unwrap(value): Integer)
      )(_.utilizedCIDRCount)
      .optionallyWith(
        ipSetReferences.map(value =>
          value
            .map({ case (key, value) =>
              (IPSetArn.unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.ipSetReferences)
      .build()
  }
  def asReadOnly: zio.aws.networkfirewall.model.CIDRSummary.ReadOnly =
    zio.aws.networkfirewall.model.CIDRSummary.wrap(buildAwsValue())
}
object CIDRSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.CIDRSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.CIDRSummary =
      zio.aws.networkfirewall.model.CIDRSummary(
        availableCIDRCount.map(value => value),
        utilizedCIDRCount.map(value => value),
        ipSetReferences.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def availableCIDRCount: Optional[CIDRCount]
    def utilizedCIDRCount: Optional[CIDRCount]
    def ipSetReferences: Optional[
      Map[IPSetArn, zio.aws.networkfirewall.model.IPSetMetadata.ReadOnly]
    ]
    def getAvailableCIDRCount: ZIO[Any, AwsError, CIDRCount] =
      AwsError.unwrapOptionField("availableCIDRCount", availableCIDRCount)
    def getUtilizedCIDRCount: ZIO[Any, AwsError, CIDRCount] =
      AwsError.unwrapOptionField("utilizedCIDRCount", utilizedCIDRCount)
    def getIpSetReferences: ZIO[Any, AwsError, Map[
      IPSetArn,
      zio.aws.networkfirewall.model.IPSetMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField("ipSetReferences", ipSetReferences)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.CIDRSummary
  ) extends zio.aws.networkfirewall.model.CIDRSummary.ReadOnly {
    override val availableCIDRCount: Optional[CIDRCount] = zio.aws.core.internal
      .optionalFromNullable(impl.availableCIDRCount())
      .map(value => zio.aws.networkfirewall.model.primitives.CIDRCount(value))
    override val utilizedCIDRCount: Optional[CIDRCount] = zio.aws.core.internal
      .optionalFromNullable(impl.utilizedCIDRCount())
      .map(value => zio.aws.networkfirewall.model.primitives.CIDRCount(value))
    override val ipSetReferences: Optional[
      Map[IPSetArn, zio.aws.networkfirewall.model.IPSetMetadata.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.ipSetReferences())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.networkfirewall.model.primitives.IPSetArn(
              key
            ) -> zio.aws.networkfirewall.model.IPSetMetadata.wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.CIDRSummary
  ): zio.aws.networkfirewall.model.CIDRSummary.ReadOnly = new Wrapper(impl)
}
