package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.networkfirewall.model.primitives.CollectionMember_String
import scala.jdk.CollectionConverters.*
final case class SubnetMapping(subnetId: CollectionMember_String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.SubnetMapping = {
    import SubnetMapping.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.SubnetMapping
      .builder()
      .subnetId(CollectionMember_String.unwrap(subnetId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.networkfirewall.model.SubnetMapping.ReadOnly =
    zio.aws.networkfirewall.model.SubnetMapping.wrap(buildAwsValue())
}
object SubnetMapping {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.SubnetMapping
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.SubnetMapping =
      zio.aws.networkfirewall.model.SubnetMapping(subnetId)
    def subnetId: CollectionMember_String
    def getSubnetId: ZIO[Any, Nothing, CollectionMember_String] =
      ZIO.succeed(subnetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.SubnetMapping
  ) extends zio.aws.networkfirewall.model.SubnetMapping.ReadOnly {
    override val subnetId: CollectionMember_String =
      zio.aws.networkfirewall.model.primitives
        .CollectionMember_String(impl.subnetId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.SubnetMapping
  ): zio.aws.networkfirewall.model.SubnetMapping.ReadOnly = new Wrapper(impl)
}
