package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class StatefulRule(
    action: zio.aws.networkfirewall.model.StatefulAction,
    header: zio.aws.networkfirewall.model.Header,
    ruleOptions: Iterable[zio.aws.networkfirewall.model.RuleOption]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.StatefulRule = {
    import StatefulRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.StatefulRule
      .builder()
      .action(action.unwrap)
      .header(header.buildAwsValue())
      .ruleOptions(ruleOptions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.networkfirewall.model.StatefulRule.ReadOnly =
    zio.aws.networkfirewall.model.StatefulRule.wrap(buildAwsValue())
}
object StatefulRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.StatefulRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.StatefulRule =
      zio.aws.networkfirewall.model.StatefulRule(
        action,
        header.asEditable,
        ruleOptions.map { item =>
          item.asEditable
        }
      )
    def action: zio.aws.networkfirewall.model.StatefulAction
    def header: zio.aws.networkfirewall.model.Header.ReadOnly
    def ruleOptions: List[zio.aws.networkfirewall.model.RuleOption.ReadOnly]
    def getAction
        : ZIO[Any, Nothing, zio.aws.networkfirewall.model.StatefulAction] =
      ZIO.succeed(action)
    def getHeader
        : ZIO[Any, Nothing, zio.aws.networkfirewall.model.Header.ReadOnly] =
      ZIO.succeed(header)
    def getRuleOptions: ZIO[Any, Nothing, List[
      zio.aws.networkfirewall.model.RuleOption.ReadOnly
    ]] = ZIO.succeed(ruleOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.StatefulRule
  ) extends zio.aws.networkfirewall.model.StatefulRule.ReadOnly {
    override val action: zio.aws.networkfirewall.model.StatefulAction =
      zio.aws.networkfirewall.model.StatefulAction.wrap(impl.action())
    override val header: zio.aws.networkfirewall.model.Header.ReadOnly =
      zio.aws.networkfirewall.model.Header.wrap(impl.header())
    override val ruleOptions
        : List[zio.aws.networkfirewall.model.RuleOption.ReadOnly] = impl
      .ruleOptions()
      .asScala
      .map { item =>
        zio.aws.networkfirewall.model.RuleOption.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.StatefulRule
  ): zio.aws.networkfirewall.model.StatefulRule.ReadOnly = new Wrapper(impl)
}
