package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.networkfirewall.model.primitives.UpdateToken
import scala.jdk.CollectionConverters.*
final case class UpdateFirewallPolicyResponse(
    updateToken: UpdateToken,
    firewallPolicyResponse: zio.aws.networkfirewall.model.FirewallPolicyResponse
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallPolicyResponse = {
    import UpdateFirewallPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallPolicyResponse
      .builder()
      .updateToken(UpdateToken.unwrap(updateToken): java.lang.String)
      .firewallPolicyResponse(firewallPolicyResponse.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.UpdateFirewallPolicyResponse.ReadOnly =
    zio.aws.networkfirewall.model.UpdateFirewallPolicyResponse
      .wrap(buildAwsValue())
}
object UpdateFirewallPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.UpdateFirewallPolicyResponse =
      zio.aws.networkfirewall.model.UpdateFirewallPolicyResponse(
        updateToken,
        firewallPolicyResponse.asEditable
      )
    def updateToken: UpdateToken
    def firewallPolicyResponse
        : zio.aws.networkfirewall.model.FirewallPolicyResponse.ReadOnly
    def getUpdateToken: ZIO[Any, Nothing, UpdateToken] =
      ZIO.succeed(updateToken)
    def getFirewallPolicyResponse: ZIO[
      Any,
      Nothing,
      zio.aws.networkfirewall.model.FirewallPolicyResponse.ReadOnly
    ] = ZIO.succeed(firewallPolicyResponse)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallPolicyResponse
  ) extends zio.aws.networkfirewall.model.UpdateFirewallPolicyResponse.ReadOnly {
    override val updateToken: UpdateToken =
      zio.aws.networkfirewall.model.primitives.UpdateToken(impl.updateToken())
    override val firewallPolicyResponse
        : zio.aws.networkfirewall.model.FirewallPolicyResponse.ReadOnly =
      zio.aws.networkfirewall.model.FirewallPolicyResponse
        .wrap(impl.firewallPolicyResponse())
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallPolicyResponse
  ): zio.aws.networkfirewall.model.UpdateFirewallPolicyResponse.ReadOnly =
    new Wrapper(impl)
}
