package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class PublishMetricAction(
    dimensions: Iterable[zio.aws.networkfirewall.model.Dimension]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.PublishMetricAction = {
    import PublishMetricAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.PublishMetricAction
      .builder()
      .dimensions(dimensions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.networkfirewall.model.PublishMetricAction.ReadOnly =
    zio.aws.networkfirewall.model.PublishMetricAction.wrap(buildAwsValue())
}
object PublishMetricAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.PublishMetricAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.PublishMetricAction =
      zio.aws.networkfirewall.model.PublishMetricAction(dimensions.map { item =>
        item.asEditable
      })
    def dimensions: List[zio.aws.networkfirewall.model.Dimension.ReadOnly]
    def getDimensions: ZIO[Any, Nothing, List[
      zio.aws.networkfirewall.model.Dimension.ReadOnly
    ]] = ZIO.succeed(dimensions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.PublishMetricAction
  ) extends zio.aws.networkfirewall.model.PublishMetricAction.ReadOnly {
    override val dimensions
        : List[zio.aws.networkfirewall.model.Dimension.ReadOnly] = impl
      .dimensions()
      .asScala
      .map { item =>
        zio.aws.networkfirewall.model.Dimension.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.PublishMetricAction
  ): zio.aws.networkfirewall.model.PublishMetricAction.ReadOnly = new Wrapper(
    impl
  )
}
