package zio.aws.networkfirewall.model
import scala.jdk.CollectionConverters.*
sealed trait OverrideAction {
  def unwrap
      : software.amazon.awssdk.services.networkfirewall.model.OverrideAction
}
object OverrideAction {
  def wrap(
      value: software.amazon.awssdk.services.networkfirewall.model.OverrideAction
  ): zio.aws.networkfirewall.model.OverrideAction = value match {
    case software.amazon.awssdk.services.networkfirewall.model.OverrideAction.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.networkfirewall.model.OverrideAction.DROP_TO_ALERT =>
      val r = DROP_TO_ALERT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.networkfirewall.model.OverrideAction {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.OverrideAction =
      software.amazon.awssdk.services.networkfirewall.model.OverrideAction.UNKNOWN_TO_SDK_VERSION
  }
  case object DROP_TO_ALERT
      extends zio.aws.networkfirewall.model.OverrideAction {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.OverrideAction =
      software.amazon.awssdk.services.networkfirewall.model.OverrideAction.DROP_TO_ALERT
  }
}
