package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.networkfirewall.model.primitives.{
  VpcId,
  Description,
  ResourceArn,
  ResourceId,
  ResourceName
}
import scala.jdk.CollectionConverters.*
final case class Firewall(
    firewallName: Optional[ResourceName] = Optional.Absent,
    firewallArn: Optional[ResourceArn] = Optional.Absent,
    firewallPolicyArn: ResourceArn,
    vpcId: VpcId,
    subnetMappings: Iterable[zio.aws.networkfirewall.model.SubnetMapping],
    deleteProtection: Optional[Boolean] = Optional.Absent,
    subnetChangeProtection: Optional[Boolean] = Optional.Absent,
    firewallPolicyChangeProtection: Optional[Boolean] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    firewallId: ResourceId,
    tags: Optional[Iterable[zio.aws.networkfirewall.model.Tag]] =
      Optional.Absent,
    encryptionConfiguration: Optional[
      zio.aws.networkfirewall.model.EncryptionConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.Firewall = {
    import Firewall.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.Firewall
      .builder()
      .optionallyWith(
        firewallName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.firewallName)
      .optionallyWith(
        firewallArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.firewallArn)
      .firewallPolicyArn(
        ResourceArn.unwrap(firewallPolicyArn): java.lang.String
      )
      .vpcId(VpcId.unwrap(vpcId): java.lang.String)
      .subnetMappings(subnetMappings.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(deleteProtection.map(value => value: java.lang.Boolean))(
        _.deleteProtection
      )
      .optionallyWith(
        subnetChangeProtection.map(value => value: java.lang.Boolean)
      )(_.subnetChangeProtection)
      .optionallyWith(
        firewallPolicyChangeProtection.map(value => value: java.lang.Boolean)
      )(_.firewallPolicyChangeProtection)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .firewallId(ResourceId.unwrap(firewallId): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        encryptionConfiguration.map(value => value.buildAwsValue())
      )(_.encryptionConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.networkfirewall.model.Firewall.ReadOnly =
    zio.aws.networkfirewall.model.Firewall.wrap(buildAwsValue())
}
object Firewall {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.Firewall
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.Firewall =
      zio.aws.networkfirewall.model.Firewall(
        firewallName.map(value => value),
        firewallArn.map(value => value),
        firewallPolicyArn,
        vpcId,
        subnetMappings.map { item =>
          item.asEditable
        },
        deleteProtection.map(value => value),
        subnetChangeProtection.map(value => value),
        firewallPolicyChangeProtection.map(value => value),
        description.map(value => value),
        firewallId,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        encryptionConfiguration.map(value => value.asEditable)
      )
    def firewallName: Optional[ResourceName]
    def firewallArn: Optional[ResourceArn]
    def firewallPolicyArn: ResourceArn
    def vpcId: VpcId
    def subnetMappings
        : List[zio.aws.networkfirewall.model.SubnetMapping.ReadOnly]
    def deleteProtection: Optional[Boolean]
    def subnetChangeProtection: Optional[Boolean]
    def firewallPolicyChangeProtection: Optional[Boolean]
    def description: Optional[Description]
    def firewallId: ResourceId
    def tags: Optional[List[zio.aws.networkfirewall.model.Tag.ReadOnly]]
    def encryptionConfiguration: Optional[
      zio.aws.networkfirewall.model.EncryptionConfiguration.ReadOnly
    ]
    def getFirewallName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("firewallName", firewallName)
    def getFirewallArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("firewallArn", firewallArn)
    def getFirewallPolicyArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(firewallPolicyArn)
    def getVpcId: ZIO[Any, Nothing, VpcId] = ZIO.succeed(vpcId)
    def getSubnetMappings: ZIO[Any, Nothing, List[
      zio.aws.networkfirewall.model.SubnetMapping.ReadOnly
    ]] = ZIO.succeed(subnetMappings)
    def getDeleteProtection: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("deleteProtection", deleteProtection)
    def getSubnetChangeProtection: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("subnetChangeProtection", subnetChangeProtection)
    def getFirewallPolicyChangeProtection: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "firewallPolicyChangeProtection",
        firewallPolicyChangeProtection
      )
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getFirewallId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(firewallId)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.networkfirewall.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getEncryptionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.networkfirewall.model.EncryptionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "encryptionConfiguration",
      encryptionConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.Firewall
  ) extends zio.aws.networkfirewall.model.Firewall.ReadOnly {
    override val firewallName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.firewallName())
      .map(value =>
        zio.aws.networkfirewall.model.primitives.ResourceName(value)
      )
    override val firewallArn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.firewallArn())
      .map(value => zio.aws.networkfirewall.model.primitives.ResourceArn(value))
    override val firewallPolicyArn: ResourceArn =
      zio.aws.networkfirewall.model.primitives
        .ResourceArn(impl.firewallPolicyArn())
    override val vpcId: VpcId =
      zio.aws.networkfirewall.model.primitives.VpcId(impl.vpcId())
    override val subnetMappings
        : List[zio.aws.networkfirewall.model.SubnetMapping.ReadOnly] = impl
      .subnetMappings()
      .asScala
      .map { item =>
        zio.aws.networkfirewall.model.SubnetMapping.wrap(item)
      }
      .toList
    override val deleteProtection: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.deleteProtection())
      .map(value => value: Boolean)
    override val subnetChangeProtection: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subnetChangeProtection())
        .map(value => value: Boolean)
    override val firewallPolicyChangeProtection: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.firewallPolicyChangeProtection())
        .map(value => value: Boolean)
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.networkfirewall.model.primitives.Description(value))
    override val firewallId: ResourceId =
      zio.aws.networkfirewall.model.primitives.ResourceId(impl.firewallId())
    override val tags
        : Optional[List[zio.aws.networkfirewall.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkfirewall.model.Tag.wrap(item)
          }.toList
        )
    override val encryptionConfiguration: Optional[
      zio.aws.networkfirewall.model.EncryptionConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.encryptionConfiguration())
      .map(value =>
        zio.aws.networkfirewall.model.EncryptionConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.Firewall
  ): zio.aws.networkfirewall.model.Firewall.ReadOnly = new Wrapper(impl)
}
