package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.networkfirewall.model.primitives.KeyId
import scala.jdk.CollectionConverters.*
final case class EncryptionConfiguration(
    keyId: Optional[KeyId] = Optional.Absent,
    `type`: zio.aws.networkfirewall.model.EncryptionType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.EncryptionConfiguration = {
    import EncryptionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.EncryptionConfiguration
      .builder()
      .optionallyWith(
        keyId.map(value => KeyId.unwrap(value): java.lang.String)
      )(_.keyId)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.EncryptionConfiguration.ReadOnly =
    zio.aws.networkfirewall.model.EncryptionConfiguration.wrap(buildAwsValue())
}
object EncryptionConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.EncryptionConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.EncryptionConfiguration =
      zio.aws.networkfirewall.model
        .EncryptionConfiguration(keyId.map(value => value), `type`)
    def keyId: Optional[KeyId]
    def `type`: zio.aws.networkfirewall.model.EncryptionType
    def getKeyId: ZIO[Any, AwsError, KeyId] =
      AwsError.unwrapOptionField("keyId", keyId)
    def getType
        : ZIO[Any, Nothing, zio.aws.networkfirewall.model.EncryptionType] =
      ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.EncryptionConfiguration
  ) extends zio.aws.networkfirewall.model.EncryptionConfiguration.ReadOnly {
    override val keyId: Optional[KeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.keyId())
      .map(value => zio.aws.networkfirewall.model.primitives.KeyId(value))
    override val `type`: zio.aws.networkfirewall.model.EncryptionType =
      zio.aws.networkfirewall.model.EncryptionType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.EncryptionConfiguration
  ): zio.aws.networkfirewall.model.EncryptionConfiguration.ReadOnly =
    new Wrapper(impl)
}
