package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.networkfirewall.model.primitives.{
  UpdateToken,
  ResourceName,
  ResourceArn
}
import scala.jdk.CollectionConverters.*
final case class AssociateFirewallPolicyResponse(
    firewallArn: Optional[ResourceArn] = Optional.Absent,
    firewallName: Optional[ResourceName] = Optional.Absent,
    firewallPolicyArn: Optional[ResourceArn] = Optional.Absent,
    updateToken: Optional[UpdateToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.AssociateFirewallPolicyResponse = {
    import AssociateFirewallPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.AssociateFirewallPolicyResponse
      .builder()
      .optionallyWith(
        firewallArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.firewallArn)
      .optionallyWith(
        firewallName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.firewallName)
      .optionallyWith(
        firewallPolicyArn.map(value =>
          ResourceArn.unwrap(value): java.lang.String
        )
      )(_.firewallPolicyArn)
      .optionallyWith(
        updateToken.map(value => UpdateToken.unwrap(value): java.lang.String)
      )(_.updateToken)
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.AssociateFirewallPolicyResponse.ReadOnly =
    zio.aws.networkfirewall.model.AssociateFirewallPolicyResponse
      .wrap(buildAwsValue())
}
object AssociateFirewallPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.AssociateFirewallPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkfirewall.model.AssociateFirewallPolicyResponse =
      zio.aws.networkfirewall.model.AssociateFirewallPolicyResponse(
        firewallArn.map(value => value),
        firewallName.map(value => value),
        firewallPolicyArn.map(value => value),
        updateToken.map(value => value)
      )
    def firewallArn: Optional[ResourceArn]
    def firewallName: Optional[ResourceName]
    def firewallPolicyArn: Optional[ResourceArn]
    def updateToken: Optional[UpdateToken]
    def getFirewallArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("firewallArn", firewallArn)
    def getFirewallName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("firewallName", firewallName)
    def getFirewallPolicyArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("firewallPolicyArn", firewallPolicyArn)
    def getUpdateToken: ZIO[Any, AwsError, UpdateToken] =
      AwsError.unwrapOptionField("updateToken", updateToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.AssociateFirewallPolicyResponse
  ) extends zio.aws.networkfirewall.model.AssociateFirewallPolicyResponse.ReadOnly {
    override val firewallArn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.firewallArn())
      .map(value => zio.aws.networkfirewall.model.primitives.ResourceArn(value))
    override val firewallName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.firewallName())
      .map(value =>
        zio.aws.networkfirewall.model.primitives.ResourceName(value)
      )
    override val firewallPolicyArn: Optional[ResourceArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.firewallPolicyArn())
        .map(value =>
          zio.aws.networkfirewall.model.primitives.ResourceArn(value)
        )
    override val updateToken: Optional[UpdateToken] = zio.aws.core.internal
      .optionalFromNullable(impl.updateToken())
      .map(value => zio.aws.networkfirewall.model.primitives.UpdateToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.AssociateFirewallPolicyResponse
  ): zio.aws.networkfirewall.model.AssociateFirewallPolicyResponse.ReadOnly =
    new Wrapper(impl)
}
