package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.networkfirewall.model.primitives.{
  AzSubnet,
  ResourceName,
  ResourceArn,
  UpdateToken
}
import scala.jdk.CollectionConverters.*
final case class DisassociateSubnetsRequest(
    updateToken: Optional[UpdateToken] = Optional.Absent,
    firewallArn: Optional[ResourceArn] = Optional.Absent,
    firewallName: Optional[ResourceName] = Optional.Absent,
    subnetIds: Iterable[AzSubnet]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.DisassociateSubnetsRequest = {
    import DisassociateSubnetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.DisassociateSubnetsRequest
      .builder()
      .optionallyWith(
        updateToken.map(value => UpdateToken.unwrap(value): java.lang.String)
      )(_.updateToken)
      .optionallyWith(
        firewallArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.firewallArn)
      .optionallyWith(
        firewallName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.firewallName)
      .subnetIds(subnetIds.map { item =>
        AzSubnet.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.DisassociateSubnetsRequest.ReadOnly =
    zio.aws.networkfirewall.model.DisassociateSubnetsRequest
      .wrap(buildAwsValue())
}
object DisassociateSubnetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.DisassociateSubnetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.DisassociateSubnetsRequest =
      zio.aws.networkfirewall.model.DisassociateSubnetsRequest(
        updateToken.map(value => value),
        firewallArn.map(value => value),
        firewallName.map(value => value),
        subnetIds
      )
    def updateToken: Optional[UpdateToken]
    def firewallArn: Optional[ResourceArn]
    def firewallName: Optional[ResourceName]
    def subnetIds: List[AzSubnet]
    def getUpdateToken: ZIO[Any, AwsError, UpdateToken] =
      AwsError.unwrapOptionField("updateToken", updateToken)
    def getFirewallArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("firewallArn", firewallArn)
    def getFirewallName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("firewallName", firewallName)
    def getSubnetIds: ZIO[Any, Nothing, List[AzSubnet]] = ZIO.succeed(subnetIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.DisassociateSubnetsRequest
  ) extends zio.aws.networkfirewall.model.DisassociateSubnetsRequest.ReadOnly {
    override val updateToken: Optional[UpdateToken] = zio.aws.core.internal
      .optionalFromNullable(impl.updateToken())
      .map(value => zio.aws.networkfirewall.model.primitives.UpdateToken(value))
    override val firewallArn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.firewallArn())
      .map(value => zio.aws.networkfirewall.model.primitives.ResourceArn(value))
    override val firewallName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.firewallName())
      .map(value =>
        zio.aws.networkfirewall.model.primitives.ResourceName(value)
      )
    override val subnetIds: List[AzSubnet] = impl
      .subnetIds()
      .asScala
      .map { item =>
        zio.aws.networkfirewall.model.primitives.AzSubnet(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.DisassociateSubnetsRequest
  ): zio.aws.networkfirewall.model.DisassociateSubnetsRequest.ReadOnly =
    new Wrapper(impl)
}
