package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.networkfirewall.model.primitives.ActionName
import scala.jdk.CollectionConverters.*
final case class CustomAction(
    actionName: ActionName,
    actionDefinition: zio.aws.networkfirewall.model.ActionDefinition
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.CustomAction = {
    import CustomAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.CustomAction
      .builder()
      .actionName(ActionName.unwrap(actionName): java.lang.String)
      .actionDefinition(actionDefinition.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.networkfirewall.model.CustomAction.ReadOnly =
    zio.aws.networkfirewall.model.CustomAction.wrap(buildAwsValue())
}
object CustomAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.CustomAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.CustomAction =
      zio.aws.networkfirewall.model
        .CustomAction(actionName, actionDefinition.asEditable)
    def actionName: ActionName
    def actionDefinition
        : zio.aws.networkfirewall.model.ActionDefinition.ReadOnly
    def getActionName: ZIO[Any, Nothing, ActionName] = ZIO.succeed(actionName)
    def getActionDefinition: ZIO[
      Any,
      Nothing,
      zio.aws.networkfirewall.model.ActionDefinition.ReadOnly
    ] = ZIO.succeed(actionDefinition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.CustomAction
  ) extends zio.aws.networkfirewall.model.CustomAction.ReadOnly {
    override val actionName: ActionName =
      zio.aws.networkfirewall.model.primitives.ActionName(impl.actionName())
    override val actionDefinition
        : zio.aws.networkfirewall.model.ActionDefinition.ReadOnly =
      zio.aws.networkfirewall.model.ActionDefinition
        .wrap(impl.actionDefinition())
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.CustomAction
  ): zio.aws.networkfirewall.model.CustomAction.ReadOnly = new Wrapper(impl)
}
