package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.networkfirewall.model.primitives.AvailabilityZone
import scala.jdk.CollectionConverters.*
final case class FirewallStatus(
    status: zio.aws.networkfirewall.model.FirewallStatusValue,
    configurationSyncStateSummary: zio.aws.networkfirewall.model.ConfigurationSyncState,
    syncStates: Optional[
      Map[AvailabilityZone, zio.aws.networkfirewall.model.SyncState]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.FirewallStatus = {
    import FirewallStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.FirewallStatus
      .builder()
      .status(status.unwrap)
      .configurationSyncStateSummary(configurationSyncStateSummary.unwrap)
      .optionallyWith(
        syncStates.map(value =>
          value
            .map({ case (key, value) =>
              (AvailabilityZone.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.syncStates)
      .build()
  }
  def asReadOnly: zio.aws.networkfirewall.model.FirewallStatus.ReadOnly =
    zio.aws.networkfirewall.model.FirewallStatus.wrap(buildAwsValue())
}
object FirewallStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.FirewallStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.FirewallStatus =
      zio.aws.networkfirewall.model.FirewallStatus(
        status,
        configurationSyncStateSummary,
        syncStates.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def status: zio.aws.networkfirewall.model.FirewallStatusValue
    def configurationSyncStateSummary
        : zio.aws.networkfirewall.model.ConfigurationSyncState
    def syncStates: Optional[
      Map[AvailabilityZone, zio.aws.networkfirewall.model.SyncState.ReadOnly]
    ]
    def getStatus
        : ZIO[Any, Nothing, zio.aws.networkfirewall.model.FirewallStatusValue] =
      ZIO.succeed(status)
    def getConfigurationSyncStateSummary: ZIO[
      Any,
      Nothing,
      zio.aws.networkfirewall.model.ConfigurationSyncState
    ] = ZIO.succeed(configurationSyncStateSummary)
    def getSyncStates: ZIO[Any, AwsError, Map[
      AvailabilityZone,
      zio.aws.networkfirewall.model.SyncState.ReadOnly
    ]] = AwsError.unwrapOptionField("syncStates", syncStates)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.FirewallStatus
  ) extends zio.aws.networkfirewall.model.FirewallStatus.ReadOnly {
    override val status: zio.aws.networkfirewall.model.FirewallStatusValue =
      zio.aws.networkfirewall.model.FirewallStatusValue.wrap(impl.status())
    override val configurationSyncStateSummary
        : zio.aws.networkfirewall.model.ConfigurationSyncState =
      zio.aws.networkfirewall.model.ConfigurationSyncState
        .wrap(impl.configurationSyncStateSummary())
    override val syncStates: Optional[
      Map[AvailabilityZone, zio.aws.networkfirewall.model.SyncState.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.syncStates())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.networkfirewall.model.primitives.AvailabilityZone(
              key
            ) -> zio.aws.networkfirewall.model.SyncState.wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.FirewallStatus
  ): zio.aws.networkfirewall.model.FirewallStatus.ReadOnly = new Wrapper(impl)
}
