package zio.aws.networkfirewall.model
import zio.aws.networkfirewall.model.primitives.{
  RuleCapacity,
  Description,
  ResourceArn,
  LastUpdateTime,
  ResourceName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeRuleGroupMetadataResponse(
    ruleGroupArn: ResourceArn,
    ruleGroupName: ResourceName,
    description: Optional[Description] = Optional.Absent,
    `type`: Optional[zio.aws.networkfirewall.model.RuleGroupType] =
      Optional.Absent,
    capacity: Optional[RuleCapacity] = Optional.Absent,
    statefulRuleOptions: Optional[
      zio.aws.networkfirewall.model.StatefulRuleOptions
    ] = Optional.Absent,
    lastModifiedTime: Optional[LastUpdateTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.DescribeRuleGroupMetadataResponse = {
    import DescribeRuleGroupMetadataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.DescribeRuleGroupMetadataResponse
      .builder()
      .ruleGroupArn(ResourceArn.unwrap(ruleGroupArn): java.lang.String)
      .ruleGroupName(ResourceName.unwrap(ruleGroupName): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        capacity.map(value => RuleCapacity.unwrap(value): Integer)
      )(_.capacity)
      .optionallyWith(statefulRuleOptions.map(value => value.buildAwsValue()))(
        _.statefulRuleOptions
      )
      .optionallyWith(
        lastModifiedTime.map(value => LastUpdateTime.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.DescribeRuleGroupMetadataResponse.ReadOnly =
    zio.aws.networkfirewall.model.DescribeRuleGroupMetadataResponse
      .wrap(buildAwsValue())
}
object DescribeRuleGroupMetadataResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.DescribeRuleGroupMetadataResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkfirewall.model.DescribeRuleGroupMetadataResponse =
      zio.aws.networkfirewall.model.DescribeRuleGroupMetadataResponse(
        ruleGroupArn,
        ruleGroupName,
        description.map(value => value),
        `type`.map(value => value),
        capacity.map(value => value),
        statefulRuleOptions.map(value => value.asEditable),
        lastModifiedTime.map(value => value)
      )
    def ruleGroupArn: ResourceArn
    def ruleGroupName: ResourceName
    def description: Optional[Description]
    def `type`: Optional[zio.aws.networkfirewall.model.RuleGroupType]
    def capacity: Optional[RuleCapacity]
    def statefulRuleOptions
        : Optional[zio.aws.networkfirewall.model.StatefulRuleOptions.ReadOnly]
    def lastModifiedTime: Optional[LastUpdateTime]
    def getRuleGroupArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(ruleGroupArn)
    def getRuleGroupName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(ruleGroupName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getType
        : ZIO[Any, AwsError, zio.aws.networkfirewall.model.RuleGroupType] =
      AwsError.unwrapOptionField("type", `type`)
    def getCapacity: ZIO[Any, AwsError, RuleCapacity] =
      AwsError.unwrapOptionField("capacity", capacity)
    def getStatefulRuleOptions: ZIO[
      Any,
      AwsError,
      zio.aws.networkfirewall.model.StatefulRuleOptions.ReadOnly
    ] = AwsError.unwrapOptionField("statefulRuleOptions", statefulRuleOptions)
    def getLastModifiedTime: ZIO[Any, AwsError, LastUpdateTime] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.DescribeRuleGroupMetadataResponse
  ) extends zio.aws.networkfirewall.model.DescribeRuleGroupMetadataResponse.ReadOnly {
    override val ruleGroupArn: ResourceArn =
      zio.aws.networkfirewall.model.primitives.ResourceArn(impl.ruleGroupArn())
    override val ruleGroupName: ResourceName =
      zio.aws.networkfirewall.model.primitives
        .ResourceName(impl.ruleGroupName())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.networkfirewall.model.primitives.Description(value))
    override val `type`: Optional[zio.aws.networkfirewall.model.RuleGroupType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.networkfirewall.model.RuleGroupType.wrap(value))
    override val capacity: Optional[RuleCapacity] = zio.aws.core.internal
      .optionalFromNullable(impl.capacity())
      .map(value =>
        zio.aws.networkfirewall.model.primitives.RuleCapacity(value)
      )
    override val statefulRuleOptions
        : Optional[zio.aws.networkfirewall.model.StatefulRuleOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statefulRuleOptions())
        .map(value =>
          zio.aws.networkfirewall.model.StatefulRuleOptions.wrap(value)
        )
    override val lastModifiedTime: Optional[LastUpdateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedTime())
        .map(value =>
          zio.aws.networkfirewall.model.primitives.LastUpdateTime(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.DescribeRuleGroupMetadataResponse
  ): zio.aws.networkfirewall.model.DescribeRuleGroupMetadataResponse.ReadOnly =
    new Wrapper(impl)
}
