package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteFirewallResponse(
    firewall: Optional[zio.aws.networkfirewall.model.Firewall] =
      Optional.Absent,
    firewallStatus: Optional[zio.aws.networkfirewall.model.FirewallStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.DeleteFirewallResponse = {
    import DeleteFirewallResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.DeleteFirewallResponse
      .builder()
      .optionallyWith(firewall.map(value => value.buildAwsValue()))(_.firewall)
      .optionallyWith(firewallStatus.map(value => value.buildAwsValue()))(
        _.firewallStatus
      )
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.DeleteFirewallResponse.ReadOnly =
    zio.aws.networkfirewall.model.DeleteFirewallResponse.wrap(buildAwsValue())
}
object DeleteFirewallResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.DeleteFirewallResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.DeleteFirewallResponse =
      zio.aws.networkfirewall.model.DeleteFirewallResponse(
        firewall.map(value => value.asEditable),
        firewallStatus.map(value => value.asEditable)
      )
    def firewall: Optional[zio.aws.networkfirewall.model.Firewall.ReadOnly]
    def firewallStatus
        : Optional[zio.aws.networkfirewall.model.FirewallStatus.ReadOnly]
    def getFirewall
        : ZIO[Any, AwsError, zio.aws.networkfirewall.model.Firewall.ReadOnly] =
      AwsError.unwrapOptionField("firewall", firewall)
    def getFirewallStatus: ZIO[
      Any,
      AwsError,
      zio.aws.networkfirewall.model.FirewallStatus.ReadOnly
    ] = AwsError.unwrapOptionField("firewallStatus", firewallStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.DeleteFirewallResponse
  ) extends zio.aws.networkfirewall.model.DeleteFirewallResponse.ReadOnly {
    override val firewall
        : Optional[zio.aws.networkfirewall.model.Firewall.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.firewall())
        .map(value => zio.aws.networkfirewall.model.Firewall.wrap(value))
    override val firewallStatus
        : Optional[zio.aws.networkfirewall.model.FirewallStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.firewallStatus())
        .map(value => zio.aws.networkfirewall.model.FirewallStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.DeleteFirewallResponse
  ): zio.aws.networkfirewall.model.DeleteFirewallResponse.ReadOnly =
    new Wrapper(impl)
}
