package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StatefulRuleGroupOverride(
    action: Optional[zio.aws.networkfirewall.model.OverrideAction] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.StatefulRuleGroupOverride = {
    import StatefulRuleGroupOverride.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.StatefulRuleGroupOverride
      .builder()
      .optionallyWith(action.map(value => value.unwrap))(_.action)
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.StatefulRuleGroupOverride.ReadOnly =
    zio.aws.networkfirewall.model.StatefulRuleGroupOverride
      .wrap(buildAwsValue())
}
object StatefulRuleGroupOverride {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.StatefulRuleGroupOverride
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.StatefulRuleGroupOverride =
      zio.aws.networkfirewall.model
        .StatefulRuleGroupOverride(action.map(value => value))
    def action: Optional[zio.aws.networkfirewall.model.OverrideAction]
    def getAction
        : ZIO[Any, AwsError, zio.aws.networkfirewall.model.OverrideAction] =
      AwsError.unwrapOptionField("action", action)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.StatefulRuleGroupOverride
  ) extends zio.aws.networkfirewall.model.StatefulRuleGroupOverride.ReadOnly {
    override val action
        : Optional[zio.aws.networkfirewall.model.OverrideAction] =
      zio.aws.core.internal
        .optionalFromNullable(impl.action())
        .map(value => zio.aws.networkfirewall.model.OverrideAction.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.StatefulRuleGroupOverride
  ): zio.aws.networkfirewall.model.StatefulRuleGroupOverride.ReadOnly =
    new Wrapper(impl)
}
