package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.networkfirewall.model.primitives.AddressDefinition
import scala.jdk.CollectionConverters.*
final case class Address(addressDefinition: AddressDefinition) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.Address = {
    import Address.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.Address
      .builder()
      .addressDefinition(
        AddressDefinition.unwrap(addressDefinition): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.networkfirewall.model.Address.ReadOnly =
    zio.aws.networkfirewall.model.Address.wrap(buildAwsValue())
}
object Address {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.Address
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.Address =
      zio.aws.networkfirewall.model.Address(addressDefinition)
    def addressDefinition: AddressDefinition
    def getAddressDefinition: ZIO[Any, Nothing, AddressDefinition] =
      ZIO.succeed(addressDefinition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.Address
  ) extends zio.aws.networkfirewall.model.Address.ReadOnly {
    override val addressDefinition: AddressDefinition =
      zio.aws.networkfirewall.model.primitives
        .AddressDefinition(impl.addressDefinition())
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.Address
  ): zio.aws.networkfirewall.model.Address.ReadOnly = new Wrapper(impl)
}
