package zio.aws.networkfirewall.model
import scala.jdk.CollectionConverters.*
sealed trait StatefulRuleDirection {
  def unwrap: software.amazon.awssdk.services.networkfirewall.model.StatefulRuleDirection
}
object StatefulRuleDirection {
  def wrap(
      value: software.amazon.awssdk.services.networkfirewall.model.StatefulRuleDirection
  ): zio.aws.networkfirewall.model.StatefulRuleDirection = value match {
    case software.amazon.awssdk.services.networkfirewall.model.StatefulRuleDirection.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.networkfirewall.model.StatefulRuleDirection.FORWARD =>
      val r = FORWARD
      r
    case software.amazon.awssdk.services.networkfirewall.model.StatefulRuleDirection.ANY =>
      val r = ANY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.networkfirewall.model.StatefulRuleDirection {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.StatefulRuleDirection =
      software.amazon.awssdk.services.networkfirewall.model.StatefulRuleDirection.UNKNOWN_TO_SDK_VERSION
  }
  case object FORWARD
      extends zio.aws.networkfirewall.model.StatefulRuleDirection {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.StatefulRuleDirection =
      software.amazon.awssdk.services.networkfirewall.model.StatefulRuleDirection.FORWARD
  }
  case object ANY extends zio.aws.networkfirewall.model.StatefulRuleDirection {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.StatefulRuleDirection =
      software.amazon.awssdk.services.networkfirewall.model.StatefulRuleDirection.ANY
  }
}
