package zio.aws.networkfirewall.model
import zio.aws.networkfirewall.model.primitives.ProtocolNumber
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class MatchAttributes(
    sources: Optional[Iterable[zio.aws.networkfirewall.model.Address]] =
      Optional.Absent,
    destinations: Optional[Iterable[zio.aws.networkfirewall.model.Address]] =
      Optional.Absent,
    sourcePorts: Optional[Iterable[zio.aws.networkfirewall.model.PortRange]] =
      Optional.Absent,
    destinationPorts: Optional[
      Iterable[zio.aws.networkfirewall.model.PortRange]
    ] = Optional.Absent,
    protocols: Optional[Iterable[ProtocolNumber]] = Optional.Absent,
    tcpFlags: Optional[Iterable[zio.aws.networkfirewall.model.TCPFlagField]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.MatchAttributes = {
    import MatchAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.MatchAttributes
      .builder()
      .optionallyWith(
        sources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sources)
      .optionallyWith(
        destinations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.destinations)
      .optionallyWith(
        sourcePorts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sourcePorts)
      .optionallyWith(
        destinationPorts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.destinationPorts)
      .optionallyWith(
        protocols.map(value =>
          value.map { item =>
            ProtocolNumber.unwrap(item): Integer
          }.asJavaCollection
        )
      )(_.protocols)
      .optionallyWith(
        tcpFlags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tcpFlags)
      .build()
  }
  def asReadOnly: zio.aws.networkfirewall.model.MatchAttributes.ReadOnly =
    zio.aws.networkfirewall.model.MatchAttributes.wrap(buildAwsValue())
}
object MatchAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.MatchAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.MatchAttributes =
      zio.aws.networkfirewall.model.MatchAttributes(
        sources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        destinations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sourcePorts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        destinationPorts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        protocols.map(value => value),
        tcpFlags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def sources: Optional[List[zio.aws.networkfirewall.model.Address.ReadOnly]]
    def destinations
        : Optional[List[zio.aws.networkfirewall.model.Address.ReadOnly]]
    def sourcePorts
        : Optional[List[zio.aws.networkfirewall.model.PortRange.ReadOnly]]
    def destinationPorts
        : Optional[List[zio.aws.networkfirewall.model.PortRange.ReadOnly]]
    def protocols: Optional[List[ProtocolNumber]]
    def tcpFlags
        : Optional[List[zio.aws.networkfirewall.model.TCPFlagField.ReadOnly]]
    def getSources: ZIO[Any, AwsError, List[
      zio.aws.networkfirewall.model.Address.ReadOnly
    ]] = AwsError.unwrapOptionField("sources", sources)
    def getDestinations: ZIO[Any, AwsError, List[
      zio.aws.networkfirewall.model.Address.ReadOnly
    ]] = AwsError.unwrapOptionField("destinations", destinations)
    def getSourcePorts: ZIO[Any, AwsError, List[
      zio.aws.networkfirewall.model.PortRange.ReadOnly
    ]] = AwsError.unwrapOptionField("sourcePorts", sourcePorts)
    def getDestinationPorts: ZIO[Any, AwsError, List[
      zio.aws.networkfirewall.model.PortRange.ReadOnly
    ]] = AwsError.unwrapOptionField("destinationPorts", destinationPorts)
    def getProtocols: ZIO[Any, AwsError, List[ProtocolNumber]] =
      AwsError.unwrapOptionField("protocols", protocols)
    def getTcpFlags: ZIO[Any, AwsError, List[
      zio.aws.networkfirewall.model.TCPFlagField.ReadOnly
    ]] = AwsError.unwrapOptionField("tcpFlags", tcpFlags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.MatchAttributes
  ) extends zio.aws.networkfirewall.model.MatchAttributes.ReadOnly {
    override val sources
        : Optional[List[zio.aws.networkfirewall.model.Address.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sources())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkfirewall.model.Address.wrap(item)
          }.toList
        )
    override val destinations
        : Optional[List[zio.aws.networkfirewall.model.Address.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkfirewall.model.Address.wrap(item)
          }.toList
        )
    override val sourcePorts
        : Optional[List[zio.aws.networkfirewall.model.PortRange.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourcePorts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkfirewall.model.PortRange.wrap(item)
          }.toList
        )
    override val destinationPorts
        : Optional[List[zio.aws.networkfirewall.model.PortRange.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationPorts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkfirewall.model.PortRange.wrap(item)
          }.toList
        )
    override val protocols: Optional[List[ProtocolNumber]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.protocols())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkfirewall.model.primitives.ProtocolNumber(item)
          }.toList
        )
    override val tcpFlags
        : Optional[List[zio.aws.networkfirewall.model.TCPFlagField.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tcpFlags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkfirewall.model.TCPFlagField.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.MatchAttributes
  ): zio.aws.networkfirewall.model.MatchAttributes.ReadOnly = new Wrapper(impl)
}
