package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ActionDefinition(
    publishMetricAction: Optional[
      zio.aws.networkfirewall.model.PublishMetricAction
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.ActionDefinition = {
    import ActionDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.ActionDefinition
      .builder()
      .optionallyWith(publishMetricAction.map(value => value.buildAwsValue()))(
        _.publishMetricAction
      )
      .build()
  }
  def asReadOnly: zio.aws.networkfirewall.model.ActionDefinition.ReadOnly =
    zio.aws.networkfirewall.model.ActionDefinition.wrap(buildAwsValue())
}
object ActionDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.ActionDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.ActionDefinition =
      zio.aws.networkfirewall.model
        .ActionDefinition(publishMetricAction.map(value => value.asEditable))
    def publishMetricAction
        : Optional[zio.aws.networkfirewall.model.PublishMetricAction.ReadOnly]
    def getPublishMetricAction: ZIO[
      Any,
      AwsError,
      zio.aws.networkfirewall.model.PublishMetricAction.ReadOnly
    ] = AwsError.unwrapOptionField("publishMetricAction", publishMetricAction)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.ActionDefinition
  ) extends zio.aws.networkfirewall.model.ActionDefinition.ReadOnly {
    override val publishMetricAction
        : Optional[zio.aws.networkfirewall.model.PublishMetricAction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.publishMetricAction())
        .map(value =>
          zio.aws.networkfirewall.model.PublishMetricAction.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.ActionDefinition
  ): zio.aws.networkfirewall.model.ActionDefinition.ReadOnly = new Wrapper(impl)
}
