package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.networkfirewall.model.primitives.PaginationToken
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceResponse(
    nextToken: Optional[PaginationToken] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.networkfirewall.model.Tag]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.ListTagsForResourceResponse = {
    import ListTagsForResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.ListTagsForResourceResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.ListTagsForResourceResponse.ReadOnly =
    zio.aws.networkfirewall.model.ListTagsForResourceResponse
      .wrap(buildAwsValue())
}
object ListTagsForResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.ListTagsForResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.ListTagsForResourceResponse =
      zio.aws.networkfirewall.model.ListTagsForResourceResponse(
        nextToken.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[PaginationToken]
    def tags: Optional[List[zio.aws.networkfirewall.model.Tag.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.networkfirewall.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.ListTagsForResourceResponse
  ) extends zio.aws.networkfirewall.model.ListTagsForResourceResponse.ReadOnly {
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.networkfirewall.model.primitives.PaginationToken(value)
      )
    override val tags
        : Optional[List[zio.aws.networkfirewall.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkfirewall.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.ListTagsForResourceResponse
  ): zio.aws.networkfirewall.model.ListTagsForResourceResponse.ReadOnly =
    new Wrapper(impl)
}
