package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.networkfirewall.model.primitives.{
  Description,
  VpcId,
  ResourceArn,
  ResourceName
}
import scala.jdk.CollectionConverters.*
final case class CreateFirewallRequest(
    firewallName: ResourceName,
    firewallPolicyArn: ResourceArn,
    vpcId: VpcId,
    subnetMappings: Iterable[zio.aws.networkfirewall.model.SubnetMapping],
    deleteProtection: Optional[Boolean] = Optional.Absent,
    subnetChangeProtection: Optional[Boolean] = Optional.Absent,
    firewallPolicyChangeProtection: Optional[Boolean] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.networkfirewall.model.Tag]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.CreateFirewallRequest = {
    import CreateFirewallRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.CreateFirewallRequest
      .builder()
      .firewallName(ResourceName.unwrap(firewallName): java.lang.String)
      .firewallPolicyArn(
        ResourceArn.unwrap(firewallPolicyArn): java.lang.String
      )
      .vpcId(VpcId.unwrap(vpcId): java.lang.String)
      .subnetMappings(subnetMappings.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(deleteProtection.map(value => value: java.lang.Boolean))(
        _.deleteProtection
      )
      .optionallyWith(
        subnetChangeProtection.map(value => value: java.lang.Boolean)
      )(_.subnetChangeProtection)
      .optionallyWith(
        firewallPolicyChangeProtection.map(value => value: java.lang.Boolean)
      )(_.firewallPolicyChangeProtection)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.networkfirewall.model.CreateFirewallRequest.ReadOnly =
    zio.aws.networkfirewall.model.CreateFirewallRequest.wrap(buildAwsValue())
}
object CreateFirewallRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.CreateFirewallRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.CreateFirewallRequest =
      zio.aws.networkfirewall.model.CreateFirewallRequest(
        firewallName,
        firewallPolicyArn,
        vpcId,
        subnetMappings.map { item =>
          item.asEditable
        },
        deleteProtection.map(value => value),
        subnetChangeProtection.map(value => value),
        firewallPolicyChangeProtection.map(value => value),
        description.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def firewallName: ResourceName
    def firewallPolicyArn: ResourceArn
    def vpcId: VpcId
    def subnetMappings
        : List[zio.aws.networkfirewall.model.SubnetMapping.ReadOnly]
    def deleteProtection: Optional[Boolean]
    def subnetChangeProtection: Optional[Boolean]
    def firewallPolicyChangeProtection: Optional[Boolean]
    def description: Optional[Description]
    def tags: Optional[List[zio.aws.networkfirewall.model.Tag.ReadOnly]]
    def getFirewallName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(firewallName)
    def getFirewallPolicyArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(firewallPolicyArn)
    def getVpcId: ZIO[Any, Nothing, VpcId] = ZIO.succeed(vpcId)
    def getSubnetMappings: ZIO[Any, Nothing, List[
      zio.aws.networkfirewall.model.SubnetMapping.ReadOnly
    ]] = ZIO.succeed(subnetMappings)
    def getDeleteProtection: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("deleteProtection", deleteProtection)
    def getSubnetChangeProtection: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("subnetChangeProtection", subnetChangeProtection)
    def getFirewallPolicyChangeProtection: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "firewallPolicyChangeProtection",
        firewallPolicyChangeProtection
      )
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.networkfirewall.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.CreateFirewallRequest
  ) extends zio.aws.networkfirewall.model.CreateFirewallRequest.ReadOnly {
    override val firewallName: ResourceName =
      zio.aws.networkfirewall.model.primitives.ResourceName(impl.firewallName())
    override val firewallPolicyArn: ResourceArn =
      zio.aws.networkfirewall.model.primitives
        .ResourceArn(impl.firewallPolicyArn())
    override val vpcId: VpcId =
      zio.aws.networkfirewall.model.primitives.VpcId(impl.vpcId())
    override val subnetMappings
        : List[zio.aws.networkfirewall.model.SubnetMapping.ReadOnly] = impl
      .subnetMappings()
      .asScala
      .map { item =>
        zio.aws.networkfirewall.model.SubnetMapping.wrap(item)
      }
      .toList
    override val deleteProtection: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.deleteProtection())
      .map(value => value: Boolean)
    override val subnetChangeProtection: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subnetChangeProtection())
        .map(value => value: Boolean)
    override val firewallPolicyChangeProtection: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.firewallPolicyChangeProtection())
        .map(value => value: Boolean)
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.networkfirewall.model.primitives.Description(value))
    override val tags
        : Optional[List[zio.aws.networkfirewall.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkfirewall.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.CreateFirewallRequest
  ): zio.aws.networkfirewall.model.CreateFirewallRequest.ReadOnly = new Wrapper(
    impl
  )
}
