package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class TCPFlagField(
    flags: Iterable[zio.aws.networkfirewall.model.TCPFlag],
    masks: Optional[Iterable[zio.aws.networkfirewall.model.TCPFlag]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.TCPFlagField = {
    import TCPFlagField.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.TCPFlagField
      .builder()
      .flagsWithStrings(flags.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .optionallyWith(
        masks.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.masksWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.networkfirewall.model.TCPFlagField.ReadOnly =
    zio.aws.networkfirewall.model.TCPFlagField.wrap(buildAwsValue())
}
object TCPFlagField {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.TCPFlagField
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.TCPFlagField =
      zio.aws.networkfirewall.model
        .TCPFlagField(flags, masks.map(value => value))
    def flags: List[zio.aws.networkfirewall.model.TCPFlag]
    def masks: Optional[List[zio.aws.networkfirewall.model.TCPFlag]]
    def getFlags
        : ZIO[Any, Nothing, List[zio.aws.networkfirewall.model.TCPFlag]] =
      ZIO.succeed(flags)
    def getMasks
        : ZIO[Any, AwsError, List[zio.aws.networkfirewall.model.TCPFlag]] =
      AwsError.unwrapOptionField("masks", masks)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.TCPFlagField
  ) extends zio.aws.networkfirewall.model.TCPFlagField.ReadOnly {
    override val flags: List[zio.aws.networkfirewall.model.TCPFlag] = impl
      .flags()
      .asScala
      .map { item =>
        zio.aws.networkfirewall.model.TCPFlag.wrap(item)
      }
      .toList
    override val masks: Optional[List[zio.aws.networkfirewall.model.TCPFlag]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.masks())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkfirewall.model.TCPFlag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.TCPFlagField
  ): zio.aws.networkfirewall.model.TCPFlagField.ReadOnly = new Wrapper(impl)
}
