package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RuleGroup(
    ruleVariables: Option[zio.aws.networkfirewall.model.RuleVariables] = None,
    rulesSource: zio.aws.networkfirewall.model.RulesSource,
    statefulRuleOptions: Option[
      zio.aws.networkfirewall.model.StatefulRuleOptions
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.RuleGroup = {
    import RuleGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.RuleGroup
      .builder()
      .optionallyWith(ruleVariables.map(value => value.buildAwsValue()))(
        _.ruleVariables
      )
      .rulesSource(rulesSource.buildAwsValue())
      .optionallyWith(statefulRuleOptions.map(value => value.buildAwsValue()))(
        _.statefulRuleOptions
      )
      .build()
  }
  def asReadOnly: zio.aws.networkfirewall.model.RuleGroup.ReadOnly =
    zio.aws.networkfirewall.model.RuleGroup.wrap(buildAwsValue())
}
object RuleGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.RuleGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.RuleGroup =
      zio.aws.networkfirewall.model.RuleGroup(
        ruleVariables.map(value => value.asEditable),
        rulesSource.asEditable,
        statefulRuleOptions.map(value => value.asEditable)
      )
    def ruleVariables
        : Option[zio.aws.networkfirewall.model.RuleVariables.ReadOnly]
    def rulesSource: zio.aws.networkfirewall.model.RulesSource.ReadOnly
    def statefulRuleOptions
        : Option[zio.aws.networkfirewall.model.StatefulRuleOptions.ReadOnly]
    def getRuleVariables: ZIO[
      Any,
      AwsError,
      zio.aws.networkfirewall.model.RuleVariables.ReadOnly
    ] = AwsError.unwrapOptionField("ruleVariables", ruleVariables)
    def getRulesSource: ZIO[
      Any,
      Nothing,
      zio.aws.networkfirewall.model.RulesSource.ReadOnly
    ] = ZIO.succeed(rulesSource)
    def getStatefulRuleOptions: ZIO[
      Any,
      AwsError,
      zio.aws.networkfirewall.model.StatefulRuleOptions.ReadOnly
    ] = AwsError.unwrapOptionField("statefulRuleOptions", statefulRuleOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.RuleGroup
  ) extends zio.aws.networkfirewall.model.RuleGroup.ReadOnly {
    override val ruleVariables
        : Option[zio.aws.networkfirewall.model.RuleVariables.ReadOnly] = scala
      .Option(impl.ruleVariables())
      .map(value => zio.aws.networkfirewall.model.RuleVariables.wrap(value))
    override val rulesSource
        : zio.aws.networkfirewall.model.RulesSource.ReadOnly =
      zio.aws.networkfirewall.model.RulesSource.wrap(impl.rulesSource())
    override val statefulRuleOptions
        : Option[zio.aws.networkfirewall.model.StatefulRuleOptions.ReadOnly] =
      scala
        .Option(impl.statefulRuleOptions())
        .map(value =>
          zio.aws.networkfirewall.model.StatefulRuleOptions.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.RuleGroup
  ): zio.aws.networkfirewall.model.RuleGroup.ReadOnly = new Wrapper(impl)
}
