package zio.aws.networkfirewall.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.networkfirewall.model.primitives.ProtocolNumber
import scala.jdk.CollectionConverters.*
final case class MatchAttributes(
    sources: Option[Iterable[zio.aws.networkfirewall.model.Address]] = None,
    destinations: Option[Iterable[zio.aws.networkfirewall.model.Address]] =
      None,
    sourcePorts: Option[Iterable[zio.aws.networkfirewall.model.PortRange]] =
      None,
    destinationPorts: Option[
      Iterable[zio.aws.networkfirewall.model.PortRange]
    ] = None,
    protocols: Option[Iterable[ProtocolNumber]] = None,
    tcpFlags: Option[Iterable[zio.aws.networkfirewall.model.TCPFlagField]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.MatchAttributes = {
    import MatchAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.MatchAttributes
      .builder()
      .optionallyWith(
        sources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sources)
      .optionallyWith(
        destinations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.destinations)
      .optionallyWith(
        sourcePorts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sourcePorts)
      .optionallyWith(
        destinationPorts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.destinationPorts)
      .optionallyWith(
        protocols.map(value =>
          value.map { item =>
            ProtocolNumber.unwrap(item): Integer
          }.asJavaCollection
        )
      )(_.protocols)
      .optionallyWith(
        tcpFlags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tcpFlags)
      .build()
  }
  def asReadOnly: zio.aws.networkfirewall.model.MatchAttributes.ReadOnly =
    zio.aws.networkfirewall.model.MatchAttributes.wrap(buildAwsValue())
}
object MatchAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.MatchAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.MatchAttributes =
      zio.aws.networkfirewall.model.MatchAttributes(
        sources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        destinations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sourcePorts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        destinationPorts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        protocols.map(value => value),
        tcpFlags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def sources: Option[List[zio.aws.networkfirewall.model.Address.ReadOnly]]
    def destinations
        : Option[List[zio.aws.networkfirewall.model.Address.ReadOnly]]
    def sourcePorts
        : Option[List[zio.aws.networkfirewall.model.PortRange.ReadOnly]]
    def destinationPorts
        : Option[List[zio.aws.networkfirewall.model.PortRange.ReadOnly]]
    def protocols: Option[List[ProtocolNumber]]
    def tcpFlags
        : Option[List[zio.aws.networkfirewall.model.TCPFlagField.ReadOnly]]
    def getSources: ZIO[Any, AwsError, List[
      zio.aws.networkfirewall.model.Address.ReadOnly
    ]] = AwsError.unwrapOptionField("sources", sources)
    def getDestinations: ZIO[Any, AwsError, List[
      zio.aws.networkfirewall.model.Address.ReadOnly
    ]] = AwsError.unwrapOptionField("destinations", destinations)
    def getSourcePorts: ZIO[Any, AwsError, List[
      zio.aws.networkfirewall.model.PortRange.ReadOnly
    ]] = AwsError.unwrapOptionField("sourcePorts", sourcePorts)
    def getDestinationPorts: ZIO[Any, AwsError, List[
      zio.aws.networkfirewall.model.PortRange.ReadOnly
    ]] = AwsError.unwrapOptionField("destinationPorts", destinationPorts)
    def getProtocols: ZIO[Any, AwsError, List[ProtocolNumber]] =
      AwsError.unwrapOptionField("protocols", protocols)
    def getTcpFlags: ZIO[Any, AwsError, List[
      zio.aws.networkfirewall.model.TCPFlagField.ReadOnly
    ]] = AwsError.unwrapOptionField("tcpFlags", tcpFlags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.MatchAttributes
  ) extends zio.aws.networkfirewall.model.MatchAttributes.ReadOnly {
    override val sources
        : Option[List[zio.aws.networkfirewall.model.Address.ReadOnly]] = scala
      .Option(impl.sources())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.networkfirewall.model.Address.wrap(item)
        }.toList
      )
    override val destinations
        : Option[List[zio.aws.networkfirewall.model.Address.ReadOnly]] = scala
      .Option(impl.destinations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.networkfirewall.model.Address.wrap(item)
        }.toList
      )
    override val sourcePorts
        : Option[List[zio.aws.networkfirewall.model.PortRange.ReadOnly]] = scala
      .Option(impl.sourcePorts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.networkfirewall.model.PortRange.wrap(item)
        }.toList
      )
    override val destinationPorts
        : Option[List[zio.aws.networkfirewall.model.PortRange.ReadOnly]] = scala
      .Option(impl.destinationPorts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.networkfirewall.model.PortRange.wrap(item)
        }.toList
      )
    override val protocols: Option[List[ProtocolNumber]] = scala
      .Option(impl.protocols())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.networkfirewall.model.primitives.ProtocolNumber(item)
        }.toList
      )
    override val tcpFlags
        : Option[List[zio.aws.networkfirewall.model.TCPFlagField.ReadOnly]] =
      scala
        .Option(impl.tcpFlags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkfirewall.model.TCPFlagField.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.MatchAttributes
  ): zio.aws.networkfirewall.model.MatchAttributes.ReadOnly = new Wrapper(impl)
}
