package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.networkfirewall.model.primitives.RulesString
import scala.jdk.CollectionConverters.*
final case class RulesSource(
    rulesString: Option[RulesString] = None,
    rulesSourceList: Option[zio.aws.networkfirewall.model.RulesSourceList] =
      None,
    statefulRules: Option[
      Iterable[zio.aws.networkfirewall.model.StatefulRule]
    ] = None,
    statelessRulesAndCustomActions: Option[
      zio.aws.networkfirewall.model.StatelessRulesAndCustomActions
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.RulesSource = {
    import RulesSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.RulesSource
      .builder()
      .optionallyWith(
        rulesString.map(value => RulesString.unwrap(value): java.lang.String)
      )(_.rulesString)
      .optionallyWith(rulesSourceList.map(value => value.buildAwsValue()))(
        _.rulesSourceList
      )
      .optionallyWith(
        statefulRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.statefulRules)
      .optionallyWith(
        statelessRulesAndCustomActions.map(value => value.buildAwsValue())
      )(_.statelessRulesAndCustomActions)
      .build()
  }
  def asReadOnly: zio.aws.networkfirewall.model.RulesSource.ReadOnly =
    zio.aws.networkfirewall.model.RulesSource.wrap(buildAwsValue())
}
object RulesSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.RulesSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.RulesSource =
      zio.aws.networkfirewall.model.RulesSource(
        rulesString.map(value => value),
        rulesSourceList.map(value => value.asEditable),
        statefulRules.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        statelessRulesAndCustomActions.map(value => value.asEditable)
      )
    def rulesString: Option[RulesString]
    def rulesSourceList
        : Option[zio.aws.networkfirewall.model.RulesSourceList.ReadOnly]
    def statefulRules
        : Option[List[zio.aws.networkfirewall.model.StatefulRule.ReadOnly]]
    def statelessRulesAndCustomActions: Option[
      zio.aws.networkfirewall.model.StatelessRulesAndCustomActions.ReadOnly
    ]
    def getRulesString: ZIO[Any, AwsError, RulesString] =
      AwsError.unwrapOptionField("rulesString", rulesString)
    def getRulesSourceList: ZIO[
      Any,
      AwsError,
      zio.aws.networkfirewall.model.RulesSourceList.ReadOnly
    ] = AwsError.unwrapOptionField("rulesSourceList", rulesSourceList)
    def getStatefulRules: ZIO[Any, AwsError, List[
      zio.aws.networkfirewall.model.StatefulRule.ReadOnly
    ]] = AwsError.unwrapOptionField("statefulRules", statefulRules)
    def getStatelessRulesAndCustomActions: ZIO[
      Any,
      AwsError,
      zio.aws.networkfirewall.model.StatelessRulesAndCustomActions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "statelessRulesAndCustomActions",
      statelessRulesAndCustomActions
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.RulesSource
  ) extends zio.aws.networkfirewall.model.RulesSource.ReadOnly {
    override val rulesString: Option[RulesString] = scala
      .Option(impl.rulesString())
      .map(value => zio.aws.networkfirewall.model.primitives.RulesString(value))
    override val rulesSourceList
        : Option[zio.aws.networkfirewall.model.RulesSourceList.ReadOnly] = scala
      .Option(impl.rulesSourceList())
      .map(value => zio.aws.networkfirewall.model.RulesSourceList.wrap(value))
    override val statefulRules
        : Option[List[zio.aws.networkfirewall.model.StatefulRule.ReadOnly]] =
      scala
        .Option(impl.statefulRules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkfirewall.model.StatefulRule.wrap(item)
          }.toList
        )
    override val statelessRulesAndCustomActions: Option[
      zio.aws.networkfirewall.model.StatelessRulesAndCustomActions.ReadOnly
    ] = scala
      .Option(impl.statelessRulesAndCustomActions())
      .map(value =>
        zio.aws.networkfirewall.model.StatelessRulesAndCustomActions.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.RulesSource
  ): zio.aws.networkfirewall.model.RulesSource.ReadOnly = new Wrapper(impl)
}
